/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;

public class UnknownCommand
implements Runnable,
Command {
    private final String command;
    private final String message;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;

    public UnknownCommand(String string) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(string, "No command");
        this.message = "Unknown command: " + string;
    }

    public String getCommand() {
        return this.command;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public void setErrorStream(OutputStream outputStream) {
        this.err = outputStream;
    }

    @Override
    public void setExitCallback(ExitCallback exitCallback) {
        this.callback = exitCallback;
    }

    @Override
    public void run() {
        String string = this.getMessage();
        try {
            try {
                this.err.write(string.getBytes(StandardCharsets.UTF_8));
                this.err.write(10);
            }
            finally {
                this.err.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.callback != null) {
            this.callback.onExit(1, string);
        }
    }

    @Override
    public void start(ChannelSession channelSession, Environment environment) {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void destroy(ChannelSession channelSession) {
    }

    public int hashCode() {
        return Objects.hashCode(this.getCommand());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return Objects.equals(this.getCommand(), ((UnknownCommand)object).getCommand());
    }

    public String toString() {
        return this.getMessage();
    }
}

