/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.shell.TtyFilterInputStream;

public class TtyFilterOutputStream
extends FilterOutputStream {
    public static final Set OUTPUT_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.ECHO, PtyMode.INLCR, PtyMode.ICRNL, PtyMode.IGNCR));
    private final Set ttyOptions;
    private final TtyFilterInputStream echo;

    public TtyFilterOutputStream(OutputStream outputStream, TtyFilterInputStream ttyFilterInputStream, Map map) {
        this(outputStream, ttyFilterInputStream, PtyMode.resolveEnabledOptions(map, OUTPUT_OPTIONS));
    }

    public TtyFilterOutputStream(OutputStream outputStream, TtyFilterInputStream ttyFilterInputStream, Collection collection) {
        super(outputStream);
        this.ttyOptions = GenericUtils.of(collection);
        this.echo = this.ttyOptions.contains((Object)PtyMode.ECHO) ? Objects.requireNonNull(ttyFilterInputStream, "No echo stream") : ttyFilterInputStream;
    }

    @Override
    public void write(int n2) {
        if (n2 == 13) {
            this.handleCR();
        } else if (n2 == 10) {
            this.handleLF();
        } else {
            this.writeRawOutput(n2);
        }
    }

    protected void handleCR() {
        if (this.ttyOptions.contains((Object)PtyMode.ICRNL)) {
            this.writeRawOutput(10);
        } else {
            if (this.ttyOptions.contains((Object)PtyMode.IGNCR)) {
                return;
            }
            this.writeRawOutput(13);
        }
    }

    protected void handleLF() {
        if (this.ttyOptions.contains((Object)PtyMode.INLCR)) {
            this.writeRawOutput(13);
        } else {
            this.writeRawOutput(10);
        }
    }

    protected void writeRawOutput(int n2) {
        this.out.write(n2);
        if (this.ttyOptions.contains((Object)PtyMode.ECHO)) {
            this.echo.write(n2);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 == 1) {
            this.write(byArray[n2] & 0xFF);
            return;
        }
        int n4 = 0;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            int n6 = byArray[i2] & 0xFF;
            if (n6 != 13 && n6 != 10) continue;
            if (n4 < i2) {
                this.writeRawOutput(byArray, n4, i2 - n4);
            }
            n4 = i2 + 1;
            this.write(n6);
        }
        if (n4 < n5) {
            this.writeRawOutput(byArray, n4, n5 - n4);
        }
    }

    protected void writeRawOutput(byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
        if (this.ttyOptions.contains((Object)PtyMode.ECHO)) {
            this.echo.write(byArray, n2, n3);
        }
    }
}

