/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class TtyFilterInputStream
extends FilterInputStream {
    public static final Set INPUT_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.ONLCR, PtyMode.OCRNL, PtyMode.ONLRET, PtyMode.ONOCR));
    private final Set ttyOptions;
    private Buffer buffer = new ByteArrayBuffer(32, false);
    private int lastChar = -1;

    public TtyFilterInputStream(InputStream inputStream, Map map) {
        this(inputStream, PtyMode.resolveEnabledOptions(map, INPUT_OPTIONS));
    }

    public TtyFilterInputStream(InputStream inputStream, Collection collection) {
        super(Objects.requireNonNull(inputStream, "No input stream provided"));
        this.ttyOptions = GenericUtils.of(collection);
    }

    public synchronized void write(int n2) {
        this.buffer.putByte((byte)n2);
    }

    public synchronized void write(byte[] byArray, int n2, int n3) {
        if (n3 == 1) {
            this.write(byArray[n2] & 0xFF);
        } else {
            this.buffer.putBytes(byArray, n2, n3);
        }
    }

    @Override
    public synchronized int available() {
        return super.available() + this.buffer.available();
    }

    @Override
    public synchronized int read() {
        int n2 = this.readRawInput();
        if (n2 == -1) {
            return n2;
        }
        if (n2 == 13) {
            n2 = this.handleCR();
        } else if (n2 == 10) {
            n2 = this.handleLF();
        }
        this.lastChar = n2;
        return n2;
    }

    protected int handleCR() {
        if (this.ttyOptions.contains((Object)PtyMode.OCRNL)) {
            return 10;
        }
        return 13;
    }

    protected int handleLF() {
        if ((this.ttyOptions.contains((Object)PtyMode.ONLCR) || this.ttyOptions.contains((Object)PtyMode.ONOCR)) && this.lastChar != 13) {
            this.buffer = this.insertCharacter(this.buffer, 10);
            return 13;
        }
        if (this.ttyOptions.contains((Object)PtyMode.ONLRET)) {
            return 13;
        }
        return 10;
    }

    protected Buffer insertCharacter(Buffer buffer, int n2) {
        int n3 = buffer.capacity();
        int n4 = buffer.rpos();
        if (n3 > 0 && n4 > 0) {
            int n5 = buffer.wpos();
            buffer.wpos(n4 - 1);
            buffer.putByte((byte)n2);
            buffer.wpos(n5);
            buffer.rpos(n4 - 1);
            return buffer;
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(buffer.available() + 8, false);
        ((Buffer)byteArrayBuffer).putByte((byte)n2);
        byteArrayBuffer.putBuffer(buffer);
        return byteArrayBuffer;
    }

    protected int readRawInput() {
        if (this.buffer.available() > 0) {
            return this.buffer.getUByte();
        }
        return this.in.read();
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 == 1) {
            int n5 = this.read();
            if (n5 == -1) {
                return -1;
            }
            byArray[n2] = (byte)n5;
            return 1;
        }
        if (this.buffer.available() == 0) {
            this.buffer.compact();
            n4 = this.in.read(byArray, n2, n3);
            if (n4 == -1) {
                return n4;
            }
            this.buffer.putRawBytes(byArray, n2, n4);
        }
        n4 = 0;
        int n6 = n2;
        while (n4 < n3 && this.buffer.available() > 0) {
            byArray[n6] = (byte)this.read();
            ++n4;
            ++n6;
        }
        return n4;
    }
}

