/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.InvertedShellWrapper;
import org.apache.sshd.server.shell.ProcessShell;
import org.apache.sshd.server.shell.ShellFactory;

public class ProcessShellFactory
extends AbstractLoggingBean
implements ShellFactory {
    private String command;
    private List elements;

    public ProcessShellFactory() {
        this.command = "";
        this.elements = Collections.emptyList();
    }

    public ProcessShellFactory(String string, String ... stringArray) {
        this(string, GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public ProcessShellFactory(String string, List list) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(string, "No command");
        this.elements = (List)ValidateUtils.checkNotNullAndNotEmpty(list, "No parsed elements", new Object[0]);
    }

    public String getCommand() {
        return this.command;
    }

    public List getElements() {
        return this.elements;
    }

    public void setCommand(String string, String ... stringArray) {
        this.setCommand(string, GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public void setCommand(String string, List list) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(string, "No command");
        this.elements = (List)ValidateUtils.checkNotNullAndNotEmpty(list, "No parsed elements", new Object[0]);
    }

    @Override
    public Command createShell(ChannelSession channelSession) {
        InvertedShell invertedShell = this.createInvertedShell(channelSession);
        return new InvertedShellWrapper(invertedShell);
    }

    protected InvertedShell createInvertedShell(ChannelSession channelSession) {
        return new ProcessShell(this.resolveEffectiveCommand(channelSession, this.getCommand(), this.getElements()));
    }

    protected List resolveEffectiveCommand(ChannelSession channelSession, String string, List list) {
        if (!OsUtils.isWin32()) {
            return (List)ValidateUtils.checkNotNullAndNotEmpty(list, "No parsed command elements", new Object[0]);
        }
        if (GenericUtils.size(list) <= 1) {
            return (List)ValidateUtils.checkNotNullAndNotEmpty(list, "No parsed command elements", new Object[0]);
        }
        String string2 = (String)list.get(0);
        if ("cmd.exe".equalsIgnoreCase(string2)) {
            return (List)ValidateUtils.checkNotNullAndNotEmpty(list, "No parsed command elements", new Object[0]);
        }
        return Arrays.asList("cmd.exe", "/C", ValidateUtils.checkNotNullAndNotEmpty(string, "No command"));
    }
}

