/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.PuttyRequestHandler;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.TtyFilterInputStream;
import org.apache.sshd.server.shell.TtyFilterOutputStream;

public class ProcessShell
extends AbstractLoggingBean
implements InvertedShell {
    private final List command;
    private String cmdValue;
    private ServerSession session;
    private ChannelSession channelSession;
    private Process process;
    private TtyFilterOutputStream in;
    private TtyFilterInputStream out;
    private TtyFilterInputStream err;

    public ProcessShell(String ... stringArray) {
        this(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public ProcessShell(Collection collection) {
        this.command = new ArrayList(ValidateUtils.checkNotNullAndNotEmpty(collection, "No process shell command(s)", new Object[0]));
        this.cmdValue = GenericUtils.join((Iterable)collection, ' ');
    }

    @Override
    public ServerSession getServerSession() {
        return this.session;
    }

    @Override
    public void setSession(ServerSession serverSession) {
        this.session = Objects.requireNonNull(serverSession, "No server session");
        ValidateUtils.checkTrue(this.process == null, "Session set after process started");
    }

    @Override
    public ChannelSession getServerChannelSession() {
        return this.channelSession;
    }

    @Override
    public void start(ChannelSession channelSession, Environment environment) {
        Object object;
        this.channelSession = channelSession;
        Map map = this.resolveShellEnvironment(environment.getEnv());
        for (int i2 = 0; i2 < this.command.size(); ++i2) {
            object = (String)this.command.get(i2);
            if (!"$USER".equals(object)) continue;
            object = (String)map.get("USER");
            this.command.set(i2, object);
            this.cmdValue = GenericUtils.join((Iterable)this.command, ' ');
        }
        ProcessBuilder processBuilder = new ProcessBuilder(this.command);
        if (MapEntryUtils.size(map) > 0) {
            try {
                object = processBuilder.environment();
                object.putAll(map);
            }
            catch (Exception exception) {
                this.warn("start({}) - Failed ({}) to set environment for command={}: {}", channelSession, exception.getClass().getSimpleName(), this.cmdValue, exception.getMessage(), exception);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("start({}): command='{}', env={}", new Object[]{channelSession, processBuilder.command(), processBuilder.environment()});
        }
        this.process = processBuilder.start();
        object = this.resolveShellTtyOptions(environment.getPtyModes());
        this.out = new TtyFilterInputStream(this.process.getInputStream(), (Map)object);
        this.err = new TtyFilterInputStream(this.process.getErrorStream(), (Map)object);
        this.in = new TtyFilterOutputStream(this.process.getOutputStream(), this.err, (Map)object);
    }

    protected Map resolveShellEnvironment(Map map) {
        return map;
    }

    protected Map resolveShellTtyOptions(Map map) {
        if (PuttyRequestHandler.isPuttyClient(this.getServerSession())) {
            return PuttyRequestHandler.resolveShellTtyOptions(map);
        }
        return map;
    }

    @Override
    public OutputStream getInputStream() {
        return this.in;
    }

    @Override
    public InputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public int exitValue() {
        if (this.isAlive()) {
            try {
                return this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
        }
        return this.process.exitValue();
    }

    @Override
    public void destroy(ChannelSession channelSession) {
        IOException iOException;
        boolean bl2 = this.log.isDebugEnabled();
        if (this.process != null) {
            if (bl2) {
                this.log.debug("destroy({}) Destroy process for '{}'", (Object)channelSession, (Object)this.cmdValue);
            }
            this.process.destroy();
        }
        if ((iOException = IoUtils.closeQuietly(this.getInputStream(), this.getOutputStream(), this.getErrorStream())) != null) {
            this.debug("destroy({}) {} while destroy streams of '{}': {}", channelSession, iOException.getClass().getSimpleName(), this, iOException.getMessage(), iOException);
        }
    }

    public String toString() {
        return GenericUtils.isEmpty(this.cmdValue) ? super.toString() : this.cmdValue;
    }
}

