/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.apache.sshd.server.shell.InvertedShell;

public class InvertedShellWrapper
extends AbstractLoggingBean
implements Command,
ServerSessionAware {
    private final InvertedShell shell;
    private final Executor executor;
    private int bufferSize;
    private Duration pumpSleepTime;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private OutputStream shellIn;
    private InputStream shellOut;
    private InputStream shellErr;
    private ExitCallback callback;
    private boolean shutdownExecutor;

    public InvertedShellWrapper(InvertedShell invertedShell) {
        this(invertedShell, (Integer)CoreModuleProperties.BUFFER_SIZE.getRequiredDefault());
    }

    public InvertedShellWrapper(InvertedShell invertedShell, int n2) {
        this(invertedShell, null, true, n2);
    }

    public InvertedShellWrapper(InvertedShell invertedShell, Executor executor, boolean bl2, int n2) {
        this.shell = Objects.requireNonNull(invertedShell, "No shell");
        this.executor = executor == null ? ThreadUtils.newSingleThreadExecutor("shell[0x" + Integer.toHexString(invertedShell.hashCode()) + "]") : executor;
        ValidateUtils.checkTrue(n2 > 8, "Copy buffer size too small: %d", n2);
        this.bufferSize = n2;
        this.pumpSleepTime = (Duration)CoreModuleProperties.PUMP_SLEEP_TIME.getRequiredDefault();
        this.shutdownExecutor = executor == null || bl2;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public void setErrorStream(OutputStream outputStream) {
        this.err = outputStream;
    }

    @Override
    public void setExitCallback(ExitCallback exitCallback) {
        this.callback = exitCallback;
    }

    @Override
    public void setSession(ServerSession serverSession) {
        this.bufferSize = (Integer)CoreModuleProperties.BUFFER_SIZE.getRequired(serverSession);
        this.pumpSleepTime = (Duration)CoreModuleProperties.PUMP_SLEEP_TIME.getRequired(serverSession);
        ValidateUtils.checkTrue(GenericUtils.isPositive(this.pumpSleepTime), "Invalid " + CoreModuleProperties.PUMP_SLEEP_TIME + ": %d", (Object)this.pumpSleepTime);
        this.shell.setSession(serverSession);
    }

    @Override
    public synchronized void start(ChannelSession channelSession, Environment environment) {
        this.shell.start(channelSession, environment);
        this.shellIn = this.shell.getInputStream();
        this.shellOut = this.shell.getOutputStream();
        this.shellErr = this.shell.getErrorStream();
        this.executor.execute(this::pumpStreams);
    }

    @Override
    public synchronized void destroy(ChannelSession channelSession) {
        Throwable throwable = null;
        try {
            this.shell.destroy(channelSession);
        }
        catch (Throwable throwable2) {
            this.warn("destroy({}) failed ({}) to destroy shell: {}", this, throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2);
            throwable = ExceptionUtils.accumulateException(throwable, throwable2);
        }
        if (this.shutdownExecutor && this.executor instanceof ExecutorService) {
            try {
                ((ExecutorService)this.executor).shutdown();
            }
            catch (Exception exception) {
                this.warn("destroy({}) failed ({}) to shut down executor: {}", this, exception.getClass().getSimpleName(), exception.getMessage(), exception);
                throwable = ExceptionUtils.accumulateException(throwable, exception);
            }
        }
        if (throwable != null) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeSshException(throwable);
        }
    }

    protected void pumpStreams() {
        try {
            byte[] byArray = new byte[this.bufferSize];
            while (true) {
                if (this.pumpStream(this.in, this.shellIn, byArray) || this.pumpStream(this.shellOut, this.out, byArray) || this.pumpStream(this.shellErr, this.err, byArray)) {
                    continue;
                }
                if (!this.shell.isAlive() && this.in.available() <= 0 && this.shellOut.available() <= 0 && this.shellErr.available() <= 0) {
                    this.callback.onExit(this.shell.exitValue());
                    return;
                }
                Thread.sleep(this.pumpSleepTime.toMillis());
            }
        }
        catch (Throwable throwable) {
            boolean bl2 = this.log.isDebugEnabled();
            try {
                this.shell.destroy(this.shell.getServerChannelSession());
            }
            catch (Throwable throwable2) {
                this.warn("pumpStreams({}) failed ({}) to destroy shell: {}", this, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            }
            int n2 = this.shell.exitValue();
            if (bl2) {
                this.log.debug(throwable.getClass().getSimpleName() + " while pumping the streams (exit=" + n2 + "): " + throwable.getMessage(), throwable);
            }
            this.callback.onExit(n2, throwable.getClass().getSimpleName());
            return;
        }
    }

    protected boolean pumpStream(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int n2 = inputStream.available();
        if (n2 > 0) {
            int n3 = inputStream.read(byArray);
            if (n3 > 0) {
                outputStream.write(byArray, 0, n3);
                outputStream.flush();
                return true;
            }
        } else if (n2 == -1) {
            outputStream.close();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.shell;
    }
}

