/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.shell.ShellFactorySelector;

public class AggregateShellFactory
extends AbstractLoggingBean
implements ShellFactory,
ShellFactorySelector {
    protected final ShellFactory defaultFactory;
    protected final Collection selectors;

    public AggregateShellFactory(Collection collection) {
        this(collection, InteractiveProcessShellFactory.INSTANCE);
    }

    public AggregateShellFactory(Collection collection, ShellFactory shellFactory) {
        this.selectors = collection == null ? Collections.emptyList() : collection;
        this.defaultFactory = Objects.requireNonNull(shellFactory, "No default factory provided");
    }

    @Override
    public Command createShell(ChannelSession channelSession) {
        ShellFactory shellFactory = this.selectShellFactory(channelSession);
        if (shellFactory == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createShell({}) using default factory={}", (Object)channelSession, (Object)this.defaultFactory);
            }
            shellFactory = this.defaultFactory;
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("createShell({}) using selected factory={}", (Object)channelSession, (Object)shellFactory);
        }
        return shellFactory.createShell(channelSession);
    }

    @Override
    public ShellFactory selectShellFactory(ChannelSession channelSession) {
        return ShellFactorySelector.selectShellFactory(this.selectors, channelSession);
    }
}

