/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyRandomArt;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionHolder;

public class ServerUserAuthService
extends AbstractCloseable
implements Service,
ServerSessionHolder {
    private final AtomicBoolean welcomeSent = new AtomicBoolean(false);
    private final Map properties = new ConcurrentHashMap();
    private final ServerSession serverSession;
    private final WelcomeBannerPhase welcomePhase;
    private List userAuthFactories;
    private List authMethods;
    private String authUserName;
    private String authMethod;
    private String authService;
    private UserAuth currentAuth;
    private int maxAuthRequests;
    private int nbAuthRequests;

    public ServerUserAuthService(Session session) {
        boolean bl2 = this.log.isDebugEnabled();
        this.serverSession = (ServerSession)ValidateUtils.checkInstanceOf((Object)session, ServerSession.class, "Server side service used on client side: %s", (Object)session);
        if (session.isAuthenticated()) {
            throw new SshException("Session already authenticated");
        }
        this.welcomePhase = (WelcomeBannerPhase)((Object)CoreModuleProperties.WELCOME_BANNER_PHASE.getRequired(this));
        this.maxAuthRequests = (Integer)CoreModuleProperties.MAX_AUTH_REQUESTS.getRequired(this);
        List list = (List)ValidateUtils.checkNotNullAndNotEmpty(this.serverSession.getUserAuthFactories(), "No user auth factories for %s", session);
        this.userAuthFactories = new ArrayList(list);
        this.authMethods = new ArrayList();
        String string = (String)CoreModuleProperties.AUTH_METHODS.getOrNull(this);
        if (GenericUtils.isEmpty(string)) {
            for (UserAuthFactory userAuthFactory : list) {
                this.authMethods.add(new ArrayList<String>(Collections.singletonList(userAuthFactory.getName())));
            }
        } else {
            if (bl2) {
                this.log.debug("ServerUserAuthService({}) using configured methods={}", (Object)session, (Object)string);
            }
            for (String object : string.split("\\s")) {
                this.authMethods.add(new ArrayList<String>(Arrays.asList(GenericUtils.split(object, ','))));
            }
        }
        for (List list2 : this.authMethods) {
            for (String string2 : list2) {
                UserAuthFactory userAuthFactory = (UserAuthFactory)NamedResource.findByName(string2, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories);
                if (userAuthFactory != null) continue;
                throw new SshException("Configured method is not supported: " + string2);
            }
        }
        if (bl2) {
            this.log.debug("ServerUserAuthService({}) authorized authentication methods: {}", (Object)session, (Object)NamedResource.getNames(this.userAuthFactories));
        }
        session.resetAuthTimeout();
    }

    public WelcomeBannerPhase getWelcomePhase() {
        return this.welcomePhase;
    }

    @Override
    public void start() {
    }

    @Override
    public ServerSession getSession() {
        return this.getServerSession();
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public synchronized void process(int n2, Buffer buffer) {
        Boolean bl3 = Boolean.FALSE;
        ServerSession serverSession = this.getServerSession();
        boolean bl4 = this.log.isDebugEnabled();
        if (n2 == 50) {
            AtomicReference<Boolean> atomicReference = new AtomicReference<Boolean>(bl3);
            if (!this.handleUserAuthRequestMessage(serverSession, buffer, atomicReference)) {
                return;
            }
            bl3 = atomicReference.get();
        } else {
            if (WelcomeBannerPhase.FIRST_AUTHCMD.equals((Object)this.getWelcomePhase())) {
                this.sendWelcomeBanner(serverSession);
            }
            if (this.currentAuth == null) {
                throw new IllegalStateException("No current authentication mechanism for cmd=" + SshConstants.getCommandMessageName(n2));
            }
            if (bl4) {
                this.log.debug("process({}) Received authentication message={} for mechanism={}", new Object[]{serverSession, SshConstants.getCommandMessageName(n2), this.currentAuth.getName()});
            }
            buffer.rpos(buffer.rpos() - 1);
            try {
                bl3 = this.currentAuth.next(buffer);
            }
            catch (AsyncAuthException asyncAuthException) {
                asyncAuthException.addListener(bl2 -> this.asyncAuth(n2, buffer, (boolean)bl2));
                return;
            }
            catch (Exception exception) {
                this.warn("process({}) Failed ({}) to authenticate using current method={}: {}", serverSession, exception.getClass().getSimpleName(), this.currentAuth.getName(), exception.getMessage(), exception);
            }
        }
        if (bl3 == null) {
            this.handleAuthenticationInProgress(n2, buffer);
        } else if (bl3.booleanValue()) {
            this.handleAuthenticationSuccess(n2, buffer);
        } else {
            this.handleAuthenticationFailure(n2, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleUserAuthRequestMessage(ServerSession serverSession, Buffer buffer, AtomicReference atomicReference) {
        UserAuthFactory userAuthFactory;
        Object object;
        boolean bl3 = this.log.isDebugEnabled();
        if (serverSession.isAuthenticated()) {
            String string = buffer.getString();
            String string2 = buffer.getString();
            String string3 = buffer.getString();
            if (bl3) {
                this.log.debug("handleUserAuthRequestMessage({}) ignore user={}, service={}, method={} auth. request since session already authenticated", new Object[]{serverSession, string, string2, string3});
            }
            return false;
        }
        if (WelcomeBannerPhase.FIRST_REQUEST.equals((Object)this.getWelcomePhase())) {
            this.sendWelcomeBanner(serverSession);
        }
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
        String string = buffer.getString();
        String string4 = buffer.getString();
        String string5 = buffer.getString();
        if (bl3) {
            this.log.debug("handleUserAuthRequestMessage({}) Received SSH_MSG_USERAUTH_REQUEST user={}, service={}, method={}", new Object[]{serverSession, string, string4, string5});
        }
        if (this.authUserName == null || this.authService == null) {
            this.authUserName = string;
            this.authService = string4;
        } else if (this.authUserName.equals(string) && this.authService.equals(string4)) {
            ++this.nbAuthRequests;
            if (this.nbAuthRequests > this.maxAuthRequests) {
                boolean bl4 = true;
                try {
                    object = serverSession.getSessionDisconnectHandler();
                    bl4 = object == null || !object.handleAuthCountDisconnectReason(serverSession, this, string4, string5, string, this.nbAuthRequests, this.maxAuthRequests);
                }
                catch (IOException | RuntimeException exception) {
                    this.warn("handleUserAuthRequestMessage({}) failed ({}) to invoke disconnect handler due to user={}/{}, service={}/{} - {}/{} auth requests: {}", serverSession, exception.getClass().getSimpleName(), this.authUserName, string, this.authService, string4, this.nbAuthRequests, this.maxAuthRequests, exception.getMessage(), exception);
                }
                if (bl4) {
                    serverSession.disconnect(2, "Too many authentication failures: " + this.nbAuthRequests);
                    return false;
                }
                if (bl3) {
                    this.log.debug("handleUserAuthRequestMessage({}) ignore mismatched authentication counts: user={}/{}, service={}/{}: {}/{}", new Object[]{serverSession, this.authUserName, string, this.authService, string4, this.nbAuthRequests, this.maxAuthRequests});
                }
            }
        } else {
            boolean bl5 = true;
            try {
                SessionDisconnectHandler sessionDisconnectHandler = serverSession.getSessionDisconnectHandler();
                bl5 = sessionDisconnectHandler == null || !sessionDisconnectHandler.handleAuthParamsDisconnectReason(serverSession, this, this.authUserName, string, this.authService, string4);
            }
            catch (IOException | RuntimeException exception) {
                this.warn("handleUserAuthRequestMessage({}) failed ({}) to invoke disconnect handler due to user={}/{}, service={}/{} mismatched parameters: {}", serverSession, exception.getClass().getSimpleName(), this.authUserName, string, this.authService, string4, exception.getMessage(), exception);
            }
            if (bl5) {
                serverSession.disconnect(2, "Change of username or service is not allowed (" + this.authUserName + ", " + this.authService + ") -> (" + string + ", " + string4 + ")");
            } else if (bl3) {
                this.log.debug("handleUserAuthRequestMessage({}) ignore mismatched authentication parameters: user={}/{}, service={}/{}", new Object[]{serverSession, this.authUserName, string, this.authService, string4});
            }
            return false;
        }
        this.authMethod = string5;
        if (bl3) {
            this.log.debug("handleUserAuthRequestMessage({}) Authenticating user '{}' with service '{}' and method '{}' (attempt {} / {})", new Object[]{serverSession, string, string4, string5, this.nbAuthRequests, this.maxAuthRequests});
        }
        if ((userAuthFactory = (UserAuthFactory)NamedResource.findByName(string5, String.CASE_INSENSITIVE_ORDER, this.userAuthFactories)) == null) {
            if (bl3) {
                this.log.debug("handleUserAuthRequestMessage({}) no authentication factory for method={}", (Object)serverSession, (Object)string5);
            }
            return true;
        }
        this.currentAuth = (UserAuth)ValidateUtils.checkNotNull((Object)((UserAuth)userAuthFactory.createUserAuth(serverSession)), "No authenticator created for method=%s", (Object)string5);
        try {
            object = this.currentAuth.auth(serverSession, string, string4, buffer);
            atomicReference.set(object);
        }
        catch (AsyncAuthException asyncAuthException) {
            asyncAuthException.addListener(bl2 -> this.asyncAuth(50, buffer, (boolean)bl2));
            return false;
        }
        catch (Exception exception) {
            this.warn("handleUserAuthRequestMessage({}) Failed ({}) to authenticate using factory method={}: {}", serverSession, exception.getClass().getSimpleName(), string5, exception.getMessage(), exception);
        }
        return true;
    }

    protected synchronized void asyncAuth(int n2, Buffer buffer, boolean bl2) {
        try {
            if (bl2) {
                this.handleAuthenticationSuccess(n2, buffer);
            } else {
                this.handleAuthenticationFailure(n2, buffer);
            }
        }
        catch (Exception exception) {
            ServerSession serverSession = this.getServerSession();
            this.warn("asyncAuth({}) Error ({}) performing async authentication via cmd={}: {}", serverSession, exception.getClass().getSimpleName(), n2, exception.getMessage(), exception);
        }
    }

    protected void handleAuthenticationInProgress(int n2, Buffer buffer) {
        String string;
        String string2 = string = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleAuthenticationInProgress({}@{}) {}", new Object[]{string, this.getServerSession(), SshConstants.getCommandMessageName(n2)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationSuccess(int n2, Buffer buffer) {
        Object object;
        String string = Objects.requireNonNull(this.currentAuth, "No current auth").getUsername();
        ServerSession serverSession = this.getServerSession();
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("handleAuthenticationSuccess({}@{}) {}", new Object[]{string, serverSession, SshConstants.getCommandMessageName(n2)});
        }
        boolean bl3 = false;
        for (Object object2 : this.authMethods) {
            if (GenericUtils.size((Collection)object2) <= 0 || !((String)object2.get(0)).equals(this.authMethod)) continue;
            object2.remove(0);
            bl3 |= object2.isEmpty();
        }
        if (bl3) {
            int n3;
            object = (Integer)CoreModuleProperties.MAX_CONCURRENT_SESSIONS.getOrNull(serverSession);
            if (object != null && (n3 = serverSession.getActiveSessionCountForUser(string)) >= (Integer)object) {
                boolean bl4 = true;
                try {
                    SessionDisconnectHandler sessionDisconnectHandler = serverSession.getSessionDisconnectHandler();
                    bl4 = sessionDisconnectHandler == null || !sessionDisconnectHandler.handleSessionsCountDisconnectReason(serverSession, this, string, n3, (Integer)object);
                }
                catch (IOException | RuntimeException exception) {
                    this.warn("handleAuthenticationSuccess({}@{}) failed ({}) to invoke disconnect handler due to {}/{} sessions count: {}", string, serverSession, exception.getClass().getSimpleName(), n3, object, exception.getMessage(), exception);
                }
                if (bl4) {
                    serverSession.disconnect(12, "Too many concurrent connections (" + n3 + ") - max. allowed: " + object);
                    return;
                }
                if (bl2) {
                    this.log.debug("handleAuthenticationSuccess({}@{}) ignore {}/{} sessions count due to handler intervention", new Object[]{string, serverSession, n3, object});
                }
            }
            if (WelcomeBannerPhase.POST_SUCCESS.equals((Object)this.getWelcomePhase())) {
                this.sendWelcomeBanner(serverSession);
            }
            serverSession.signalAuthenticationSuccess(string, this.authService, buffer);
        } else {
            Object object2;
            object = this.authMethods.stream().filter(GenericUtils::isNotEmpty).map(list -> (String)list.get(0)).collect(Collectors.joining(","));
            if (bl2) {
                this.log.debug("handleAuthenticationSuccess({}@{}) remaining methods={}", new Object[]{string, serverSession, object});
            }
            object2 = serverSession.createBuffer((byte)51, ((String)object).length() + 8);
            ((Buffer)object2).putString((String)object);
            ((Buffer)object2).putBoolean(true);
            serverSession.writePacket((Buffer)object2);
        }
        try {
            this.currentAuth.destroy();
        }
        finally {
            this.currentAuth = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAuthenticationFailure(int n2, Buffer buffer) {
        String string;
        ServerSession serverSession = this.getServerSession();
        boolean bl2 = this.log.isDebugEnabled();
        if (WelcomeBannerPhase.FIRST_FAILURE.equals((Object)this.getWelcomePhase())) {
            this.sendWelcomeBanner(serverSession);
        }
        String string2 = string = this.currentAuth == null ? null : this.currentAuth.getUsername();
        if (bl2) {
            this.log.debug("handleAuthenticationFailure({}@{}) {}", new Object[]{string, serverSession, SshConstants.getCommandMessageName(n2)});
        }
        StringBuilder stringBuilder = new StringBuilder((this.authMethods.size() + 1) * 8);
        for (List list : this.authMethods) {
            String string3;
            if (GenericUtils.size(list) <= 0 || "none".equals(string3 = (String)list.get(0))) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string3);
        }
        String string4 = stringBuilder.toString();
        if (bl2) {
            this.log.debug("handleAuthenticationFailure({}@{}) remaining methods: {}", new Object[]{string, serverSession, string4});
        }
        buffer = serverSession.createBuffer((byte)51, string4.length() + 8);
        buffer.putString(string4);
        buffer.putBoolean(false);
        serverSession.writePacket(buffer);
        if (this.currentAuth != null) {
            try {
                this.currentAuth.destroy();
            }
            finally {
                this.currentAuth = null;
            }
        }
    }

    public IoWriteFuture sendWelcomeBanner(ServerSession serverSession) {
        if (this.welcomeSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendWelcomeBanner({}) already sent", (Object)serverSession);
            }
            return null;
        }
        String string = this.resolveWelcomeBanner(serverSession);
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        String string2 = (String)CoreModuleProperties.WELCOME_BANNER_LANGUAGE.getRequired(this);
        Buffer buffer = serverSession.createBuffer((byte)53, string.length() + GenericUtils.length(string2) + 64);
        buffer.putString(string);
        buffer.putString(string2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWelcomeBanner({}) send banner (length={}, lang={})", new Object[]{serverSession, string.length(), string2});
        }
        return serverSession.writePacket(buffer);
    }

    protected String resolveWelcomeBanner(ServerSession serverSession) {
        Object object;
        Object object2 = CoreModuleProperties.WELCOME_BANNER.getOrNull(this);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof CharSequence) {
            object = object2.toString();
            if (GenericUtils.isEmpty((CharSequence)object)) {
                return null;
            }
            if ("#auto-welcome-banner".equalsIgnoreCase((String)object)) {
                try {
                    return KeyRandomArt.combine(serverSession, ' ', serverSession.getKeyPairProvider());
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
            if (!((String)object).contains("://")) {
                return object;
            }
            try {
                object2 = new URI((String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.log.error("resolveWelcomeBanner({}) bad path URI {}: {}", new Object[]{serverSession, object, uRISyntaxException.getMessage()});
                throw new MalformedURLException(uRISyntaxException.getClass().getSimpleName() + " - bad URI (" + (String)object + "): " + uRISyntaxException.getMessage());
            }
            if (((String)object).startsWith("file:/")) {
                object2 = Paths.get((URI)object2);
            }
        }
        if (object2 instanceof File) {
            object2 = ((File)object2).toPath();
        }
        if (object2 instanceof Path) {
            object = (Path)object2;
            if (!Files.exists((Path)object, new LinkOption[0]) || Files.size((Path)object) <= 0L) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resolveWelcomeBanner({}) file is empty/does not exist {}", (Object)serverSession, object);
                }
                return null;
            }
            object2 = object.toUri();
        }
        if (object2 instanceof URI) {
            object2 = ((URI)object2).toURL();
        }
        if (object2 instanceof URL) {
            object = (Charset)CoreModuleProperties.WELCOME_BANNER_CHARSET.getRequired(this);
            return this.loadWelcomeBanner(serverSession, (URL)object2, (Charset)object);
        }
        return object2.toString();
    }

    protected String loadWelcomeBanner(ServerSession serverSession, URL uRL, Charset charset) {
        try (InputStream inputStream = uRL.openStream();){
            byte[] byArray = IoUtils.toByteArray(inputStream);
            String string = NumberUtils.isEmpty(byArray) ? "" : new String(byArray, charset);
            return string;
        }
    }

    public ServerFactoryManager getFactoryManager() {
        return this.serverSession.getFactoryManager();
    }
}

