/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensionHandler$AvailabilityPhase;
import org.apache.sshd.common.kex.extension.KexExtensionHandler$KexPhase;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.WelcomeBannerPhase;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerUserAuthService;

public abstract class AbstractServerSession
extends AbstractSession
implements ServerSession {
    private ServerProxyAcceptor proxyAcceptor;
    private SocketAddress clientAddress;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;
    private KeyboardInteractiveAuthenticator interactiveAuthenticator;
    private GSSAuthenticator gssAuthenticator;
    private HostBasedAuthenticator hostBasedAuthenticator;
    private List userAuthFactories;
    private KeyPairProvider keyPairProvider;
    private HostKeyCertificateProvider hostKeyCertificateProvider;

    protected AbstractServerSession(ServerFactoryManager serverFactoryManager, IoSession ioSession) {
        super(true, serverFactoryManager, ioSession);
    }

    @Override
    public ServerFactoryManager getFactoryManager() {
        return (ServerFactoryManager)super.getFactoryManager();
    }

    @Override
    public ServerProxyAcceptor getServerProxyAcceptor() {
        return (ServerProxyAcceptor)this.resolveEffectiveProvider(ServerProxyAcceptor.class, this.proxyAcceptor, this.getFactoryManager().getServerProxyAcceptor());
    }

    @Override
    public void setServerProxyAcceptor(ServerProxyAcceptor serverProxyAcceptor) {
        this.proxyAcceptor = serverProxyAcceptor;
    }

    @Override
    public SocketAddress getClientAddress() {
        return this.resolvePeerAddress(this.clientAddress);
    }

    public void setClientAddress(SocketAddress socketAddress) {
        this.clientAddress = socketAddress;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        return (PasswordAuthenticator)this.resolveEffectiveProvider(PasswordAuthenticator.class, this.passwordAuthenticator, serverFactoryManager.getPasswordAuthenticator());
    }

    @Override
    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        return (PublickeyAuthenticator)this.resolveEffectiveProvider(PublickeyAuthenticator.class, this.publickeyAuthenticator, serverFactoryManager.getPublickeyAuthenticator());
    }

    @Override
    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator() {
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        return (KeyboardInteractiveAuthenticator)this.resolveEffectiveProvider(KeyboardInteractiveAuthenticator.class, this.interactiveAuthenticator, serverFactoryManager.getKeyboardInteractiveAuthenticator());
    }

    @Override
    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator keyboardInteractiveAuthenticator) {
        this.interactiveAuthenticator = keyboardInteractiveAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        return (GSSAuthenticator)this.resolveEffectiveProvider(GSSAuthenticator.class, this.gssAuthenticator, serverFactoryManager.getGSSAuthenticator());
    }

    @Override
    public void setGSSAuthenticator(GSSAuthenticator gSSAuthenticator) {
        this.gssAuthenticator = gSSAuthenticator;
    }

    @Override
    public HostBasedAuthenticator getHostBasedAuthenticator() {
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        return (HostBasedAuthenticator)this.resolveEffectiveProvider(HostBasedAuthenticator.class, this.hostBasedAuthenticator, serverFactoryManager.getHostBasedAuthenticator());
    }

    @Override
    public void setHostBasedAuthenticator(HostBasedAuthenticator hostBasedAuthenticator) {
        this.hostBasedAuthenticator = hostBasedAuthenticator;
    }

    @Override
    public List getUserAuthFactories() {
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        return (List)this.resolveEffectiveFactories(this.userAuthFactories, serverFactoryManager.getUserAuthFactories());
    }

    @Override
    public void setUserAuthFactories(List list) {
        this.userAuthFactories = list;
    }

    @Override
    public KeyPairProvider getKeyPairProvider() {
        KexFactoryManager kexFactoryManager = this.getDelegate();
        return (KeyPairProvider)this.resolveEffectiveProvider(KeyPairProvider.class, this.keyPairProvider, kexFactoryManager == null ? null : ((ServerAuthenticationManager)((Object)kexFactoryManager)).getKeyPairProvider());
    }

    @Override
    public HostKeyCertificateProvider getHostKeyCertificateProvider() {
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        return (HostKeyCertificateProvider)this.resolveEffectiveProvider(HostKeyCertificateProvider.class, this.hostKeyCertificateProvider, serverFactoryManager.getHostKeyCertificateProvider());
    }

    @Override
    public void setHostKeyCertificateProvider(HostKeyCertificateProvider hostKeyCertificateProvider) {
        this.hostKeyCertificateProvider = hostKeyCertificateProvider;
    }

    @Override
    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }

    protected IoWriteFuture sendServerIdentification(List list) {
        this.serverVersion = this.resolveIdentificationString(CoreModuleProperties.SERVER_IDENTIFICATION.getName());
        this.signalSendIdentification(this.serverVersion, list);
        return this.sendIdentification(this.serverVersion, list);
    }

    @Override
    protected void checkKeys() {
    }

    @Override
    protected boolean handleServiceRequest(String string, Buffer buffer) {
        ServerUserAuthService serverUserAuthService;
        Service service;
        boolean bl2 = super.handleServiceRequest(string, buffer);
        if (!bl2) {
            return false;
        }
        if ("ssh-userauth".equals(string) && (service = this.currentService.getService()) instanceof ServerUserAuthService && WelcomeBannerPhase.IMMEDIATE.equals((Object)(serverUserAuthService = (ServerUserAuthService)service).getWelcomePhase())) {
            serverUserAuthService.sendWelcomeBanner(this);
        }
        return true;
    }

    @Override
    public void startService(String string, Buffer buffer) {
        Service service;
        ValidateUtils.checkNotNullAndNotEmpty(string, "No service name specified");
        ServerFactoryManager serverFactoryManager = this.getFactoryManager();
        ServiceFactory serviceFactory = (ServiceFactory)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, serverFactoryManager.getServiceFactories());
        Service service2 = service = serviceFactory == null ? null : serviceFactory.create(this);
        if (service == null) {
            try {
                SessionDisconnectHandler sessionDisconnectHandler = this.getSessionDisconnectHandler();
                if (sessionDisconnectHandler != null && sessionDisconnectHandler.handleUnsupportedServiceDisconnectReason(this, 5, string, buffer)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("startService({}) ignore unknown service={} by handler", (Object)this, (Object)string);
                    }
                    return;
                }
            }
            catch (IOException | RuntimeException exception) {
                this.warn("startService({})[{}] failed ({}) to invoke disconnect handler: {}", this, string, exception.getClass().getSimpleName(), exception.getMessage(), exception);
            }
            throw new SshException(7, "Unknown service: " + string);
        }
        this.currentService.set(service, serviceFactory.getName(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture signalAuthenticationSuccess(String string, String string2, Buffer buffer) {
        IoWriteFuture ioWriteFuture;
        KexState kexState = (KexState)((Object)this.kexState.get());
        if (!KexState.DONE.equals((Object)kexState)) {
            throw new SshException(2, "Authentication success signalled though KEX state=" + (Object)((Object)kexState));
        }
        KexExtensionHandler kexExtensionHandler = this.getKexExtensionHandler();
        if (kexExtensionHandler != null && kexExtensionHandler.isKexExtensionsAvailable(this, KexExtensionHandler$AvailabilityPhase.AUTHOK)) {
            kexExtensionHandler.sendKexExtensions(this, KexExtensionHandler$KexPhase.AUTHOK);
        }
        Buffer buffer2 = this.createBuffer((byte)52, 8);
        IoSession ioSession = this.getIoSession();
        Object object = this.encodeLock;
        synchronized (object) {
            Buffer buffer3 = this.resolveOutputPacket(buffer2);
            this.setUsername(string);
            this.setAuthenticated();
            this.startService(string2, buffer);
            ioWriteFuture = ioSession.writeBuffer(buffer3);
        }
        this.resetIdleTimeout();
        this.log.info("Session {}@{} authenticated", (Object)string, (Object)ioSession.getRemoteAddress());
        return ioWriteFuture;
    }

    @Override
    protected void handleServiceAccept(String string, Buffer buffer) {
        super.handleServiceAccept(string, buffer);
        try {
            SessionDisconnectHandler sessionDisconnectHandler = this.getSessionDisconnectHandler();
            if (sessionDisconnectHandler != null && sessionDisconnectHandler.handleUnsupportedServiceDisconnectReason(this, 6, string, buffer)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleServiceAccept({}) ignore unknown service={} by handler", (Object)this, (Object)string);
                }
                return;
            }
        }
        catch (IOException | RuntimeException exception) {
            this.warn("handleServiceAccept({}) failed ({}) to invoke disconnect handler of unknown service={}: {}", this, exception.getClass().getSimpleName(), string, exception.getMessage(), exception);
        }
        this.disconnect(2, "Unsupported packet: SSH_MSG_SERVICE_ACCEPT for " + string);
    }

    @Override
    protected byte[] sendKexInit(Map map) {
        this.mergeProposals(this.serverProposal, map);
        return super.sendKexInit(map);
    }

    @Override
    protected void setKexSeed(byte ... byArray) {
        this.setServerKexData(byArray);
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager factoryManager) {
        Iterable iterable;
        Object object;
        ValidateUtils.checkTrue(factoryManager == this.getFactoryManager(), "Mismatched signatures proposed factory manager");
        KeyPairProvider keyPairProvider = this.getKeyPairProvider();
        Collection collection = null;
        try {
            if (keyPairProvider != null) {
                collection = GenericUtils.stream(keyPairProvider.getKeyTypes(this)).collect(Collectors.toSet());
                object = this.getHostKeyCertificateProvider();
                if (object != null) {
                    iterable = object.loadCertificates(this);
                    for (OpenSshCertificate openSshCertificate : iterable) {
                        if (OpenSshCertificate$Type.HOST.equals((Object)openSshCertificate.getType())) {
                            String string = openSshCertificate.getRawKeyType();
                            if (collection.contains(string)) {
                                collection.add(openSshCertificate.getKeyType());
                                continue;
                            }
                            this.log.info("resolveAvailableSignaturesProposal({}) No private key of type={} available in provided certificate", (Object)this, (Object)string);
                            continue;
                        }
                        this.log.error("resolveAvailableSignaturesProposal({}) certificate {} is not a host certificate", (Object)this, (Object)KeyUtils.getFingerPrint(openSshCertificate));
                    }
                }
            }
        }
        catch (Error error) {
            this.warn("resolveAvailableSignaturesProposal({}) failed ({}) to get key types: {}", this, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        object = NamedResource.getNameList(this.getSignatureFactories());
        if (collection == null || GenericUtils.isEmpty((Collection)object)) {
            return this.resolveEmptySignaturesProposal((Iterable)object, collection);
        }
        iterable = SignatureFactory.resolveSignatureFactoryNamesProposal(collection, (Collection)object);
        if (GenericUtils.isEmpty((Collection)iterable)) {
            return this.resolveEmptySignaturesProposal((Iterable)object, collection);
        }
        return GenericUtils.join(iterable, ',');
    }

    protected String resolveEmptySignaturesProposal(Iterable iterable, Iterable iterable2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveEmptySignaturesProposal({})[{}] none of the keys appears in supported list: {}", new Object[]{this, iterable2, iterable});
        }
        return null;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) {
        SshException sshException;
        List list;
        int n2;
        ServerProxyAcceptor serverProxyAcceptor = this.getServerProxyAcceptor();
        int n3 = buffer.rpos();
        boolean bl2 = this.log.isDebugEnabled();
        if (serverProxyAcceptor != null) {
            try {
                boolean bl3 = serverProxyAcceptor.acceptServerProxyMetadata(this, buffer);
                if (!bl3) {
                    buffer.rpos(n3);
                    return false;
                }
            }
            catch (Throwable throwable) {
                this.warn("readIdentification({}) failed ({}) to accept proxy metadata: {}", this, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new SshException(throwable);
            }
        }
        String string = this.clientVersion = (n2 = GenericUtils.size(list = this.doReadIdentification(buffer, true))) <= 0 ? null : (String)list.remove(n2 - 1);
        if (GenericUtils.isEmpty(this.clientVersion)) {
            buffer.rpos(n3);
            return false;
        }
        if (bl2) {
            this.log.debug("readIdentification({}) client version string: {}", (Object)this, (Object)this.clientVersion);
        }
        if ((sshException = SessionContext.isValidVersionPrefix(this.clientVersion) ? (n2 > 1 ? new SshException(2, "Unexpected extra " + (n2 - 1) + " lines from client=" + this.clientVersion) : null) : new SshException(8, "Unsupported protocol version: " + this.clientVersion)) != null) {
            IoSession ioSession = this.getIoSession();
            ioSession.writeBuffer(new ByteArrayBuffer((sshException.getMessage() + "\n").getBytes(StandardCharsets.UTF_8))).addListener(ioWriteFuture -> this.close(true));
            throw sshException;
        }
        this.signalPeerIdentificationReceived(this.clientVersion, list);
        this.kexState.set(KexState.INIT);
        this.sendKexInit();
        return true;
    }

    @Override
    protected void receiveKexInit(Map map, byte[] byArray) {
        this.mergeProposals(this.clientProposal, map);
        this.setClientKexData(byArray);
    }

    @Override
    public KeyPair getHostKey() {
        String string = this.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        String string2 = KeyUtils.getCanonicalKeyType(string);
        if (GenericUtils.isEmpty(string2)) {
            return null;
        }
        KeyPairProvider keyPairProvider = Objects.requireNonNull(this.getKeyPairProvider(), "No host keys provider");
        try {
            OpenSshCertificate openSshCertificate;
            HostKeyCertificateProvider hostKeyCertificateProvider = this.getHostKeyCertificateProvider();
            if (hostKeyCertificateProvider != null && (openSshCertificate = hostKeyCertificateProvider.loadCertificate(this, string2)) != null) {
                String string3 = openSshCertificate.getRawKeyType();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("getHostKey({}) using certified key {}/{} with ID={}", new Object[]{this, string2, string3, openSshCertificate.getId()});
                }
                KeyPair keyPair = keyPairProvider.loadKey(this, string3);
                ValidateUtils.checkNotNull((Object)keyPair, "No certified private key of type=%s available", (Object)string3);
                return new KeyPair(openSshCertificate, keyPair.getPrivate());
            }
            return keyPairProvider.loadKey(this, string2);
        }
        catch (IOException | Error | GeneralSecurityException throwable) {
            this.warn("getHostKey({}) failed ({}) to load key of type={}[{}]: {}", this, throwable.getClass().getSimpleName(), string, string2, throwable.getMessage(), throwable);
            throw new RuntimeSshException(throwable);
        }
    }

    @Override
    public int getActiveSessionCountForUser(String string) {
        if (GenericUtils.isEmpty(string)) {
            return 0;
        }
        IoSession ioSession = this.getIoSession();
        IoService ioService = ioSession.getService();
        Map map = ioService.getManagedSessions();
        if (MapEntryUtils.isEmpty(map)) {
            return 0;
        }
        int n2 = 0;
        for (IoSession ioSession2 : map.values()) {
            String string2;
            ServerSession serverSession = (ServerSession)((Object)AbstractServerSession.getSession(ioSession2, true));
            if (serverSession == null || GenericUtils.isEmpty(string2 = serverSession.getUsername()) || !Objects.equals(string2, string)) continue;
            ++n2;
        }
        return n2;
    }

    public long getId() {
        IoSession ioSession = this.getIoSession();
        return ioSession.getId();
    }

    @Override
    protected ConnectionService getConnectionService() {
        return this.currentService instanceof ConnectionService ? (ConnectionService)((Object)this.currentService) : null;
    }
}

