/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.writer.openssh.OpenSSHKeyPairResourceWriter;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider$ValidatingObjectInputStream;

public class SimpleGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public SimpleGeneratorHostKeyProvider() {
    }

    public SimpleGeneratorHostKeyProvider(Path path) {
        this.setPath(path);
    }

    /*
     * Loose catch block
     */
    @Override
    protected Iterable doReadKeyPairs(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            if (this.isJavaSerialization(bufferedInputStream, namedResource)) {
                try (SimpleGeneratorHostKeyProvider$ValidatingObjectInputStream simpleGeneratorHostKeyProvider$ValidatingObjectInputStream = new SimpleGeneratorHostKeyProvider$ValidatingObjectInputStream(bufferedInputStream);){
                    List<KeyPair> list = Collections.singletonList((KeyPair)simpleGeneratorHostKeyProvider$ValidatingObjectInputStream.readObject());
                    return list;
                }
                {
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new InvalidKeySpecException("Cannot de-serialize " + namedResource + ": missing classes: " + classNotFoundException.getMessage(), classNotFoundException);
                    }
                }
            }
            Iterable iterable = SecurityUtils.loadKeyPairIdentities(null, namedResource, bufferedInputStream, null);
            return iterable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJavaSerialization(BufferedInputStream bufferedInputStream, NamedResource namedResource) {
        bufferedInputStream.mark(2);
        try {
            byte[] byArray = new byte[2];
            int n2 = bufferedInputStream.read(byArray);
            if (n2 != 2) {
                throw new StreamCorruptedException("File " + namedResource + " is not a host key");
            }
            short s2 = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
            boolean bl2 = s2 == -21267;
            return bl2;
        }
        finally {
            bufferedInputStream.reset();
        }
    }

    @Override
    protected void doWriteKeyPair(NamedResource namedResource, KeyPair keyPair, OutputStream outputStream) {
        OpenSSHKeyPairResourceWriter openSSHKeyPairResourceWriter = new OpenSSHKeyPairResourceWriter();
        try (OutputStream outputStream2 = outputStream;){
            openSSHKeyPairResourceWriter.writePrivateKey(keyPair, "host key", null, outputStream2);
        }
    }
}

