/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.AlgorithmNameProvider;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractGeneratorHostKeyProvider
extends AbstractKeyPairProvider
implements AlgorithmNameProvider,
KeySizeIndicator {
    public static final String DEFAULT_ALGORITHM = "EC";
    public static final boolean DEFAULT_ALLOWED_TO_OVERWRITE = true;
    private final AtomicReference keyPairHolder = new AtomicReference();
    private Path path;
    private String algorithm = "EC";
    private int keySize;
    private AlgorithmParameterSpec keySpec;
    private boolean overwriteAllowed = true;
    private boolean enforceFilePermissions = true;

    protected AbstractGeneratorHostKeyProvider() {
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path == null ? null : path.toAbsolutePath();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int n2) {
        this.keySize = n2;
    }

    public AlgorithmParameterSpec getKeySpec() {
        return this.keySpec;
    }

    public void setKeySpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.keySpec = algorithmParameterSpec;
    }

    public boolean isOverwriteAllowed() {
        return this.overwriteAllowed;
    }

    public void setOverwriteAllowed(boolean bl2) {
        this.overwriteAllowed = bl2;
    }

    public boolean hasStrictFilePermissions() {
        return this.enforceFilePermissions;
    }

    public void setStrictFilePermissions(boolean bl2) {
        this.enforceFilePermissions = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLoadedKeys() {
        Iterable iterable;
        AtomicReference atomicReference = this.keyPairHolder;
        synchronized (atomicReference) {
            iterable = this.keyPairHolder.getAndSet(null);
        }
        if (iterable != null && this.log.isDebugEnabled()) {
            this.log.debug("clearLoadedKeys({}) removed keys", (Object)this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List loadKeys(SessionContext sessionContext) {
        Iterable iterable;
        Path path = this.getPath();
        ArrayList<KeyPair> arrayList = this.keyPairHolder;
        synchronized (arrayList) {
            iterable = (Iterable)this.keyPairHolder.get();
            if (iterable == null) {
                try {
                    iterable = this.resolveKeyPairs(sessionContext, path);
                    if (iterable != null) {
                        this.keyPairHolder.set(iterable);
                    }
                }
                catch (Exception exception) {
                    this.warn("loadKeys({}) Failed ({}) to resolve: {}", path, exception.getClass().getSimpleName(), exception.getMessage(), exception);
                }
            }
        }
        arrayList = Collections.emptyList();
        if (iterable instanceof List) {
            arrayList = (List)iterable;
        } else if (iterable != null) {
            arrayList = new ArrayList<KeyPair>();
            for (KeyPair keyPair : iterable) {
                if (keyPair == null) continue;
                arrayList.add(keyPair);
            }
        }
        return arrayList;
    }

    protected Iterable resolveKeyPairs(SessionContext sessionContext, Path path) {
        Serializable serializable;
        Object object;
        String string = this.getAlgorithm();
        if (path != null) {
            try {
                object = this.loadFromFile(sessionContext, string, path);
                serializable = (KeyPair)GenericUtils.head((Iterable)object);
                if (serializable != null) {
                    return object;
                }
            }
            catch (Exception exception) {
                this.warn("resolveKeyPair({}) Failed ({}) to load: {}", path, exception.getClass().getSimpleName(), exception.getMessage(), exception);
            }
        }
        object = null;
        try {
            object = this.generateKeyPair(string);
            if (object == null) {
                return null;
            }
            if (this.log.isDebugEnabled()) {
                serializable = ((KeyPair)object).getPublic();
                this.log.debug("resolveKeyPair({}) generated {} key={}-{}", new Object[]{path, string, KeyUtils.getKeyType((Key)serializable), KeyUtils.getFingerPrint((PublicKey)serializable)});
            }
        }
        catch (Exception exception) {
            this.warn("resolveKeyPair({})[{}] Failed ({}) to generate {} key-pair: {}", path, string, exception.getClass().getSimpleName(), string, exception.getMessage(), exception);
            return null;
        }
        if (path != null) {
            try {
                this.writeKeyPair((KeyPair)object, path);
            }
            catch (Exception exception) {
                this.warn("resolveKeyPair({})[{}] Failed ({}) to write {} key: {}", string, path, exception.getClass().getSimpleName(), string, exception.getMessage(), exception);
            }
        }
        return Collections.singletonList(object);
    }

    protected Iterable loadFromFile(SessionContext sessionContext, String string, Path path) {
        LinkOption[] linkOptionArray = IoUtils.getLinkOptions(true);
        if (!Files.exists(path, linkOptionArray) || !Files.isRegularFile(path, linkOptionArray)) {
            return null;
        }
        Iterable iterable = this.readKeyPairs(sessionContext, path, IoUtils.EMPTY_OPEN_OPTIONS);
        KeyPair keyPair = (KeyPair)GenericUtils.head(iterable);
        if (keyPair == null) {
            return null;
        }
        PublicKey publicKey = keyPair.getPublic();
        String string2 = publicKey.getAlgorithm();
        if ("ECDSA".equalsIgnoreCase(string2)) {
            string2 = DEFAULT_ALGORITHM;
        } else if ("ED25519".equalsIgnoreCase(string2)) {
            string2 = "EdDSA";
        }
        if (Objects.equals(string, string2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveKeyPair({}) loaded key={}-{}", new Object[]{path, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
            }
            return iterable;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveKeyPair({}) mismatched loaded key algorithm: expected={}, loaded={}", new Object[]{path, string, string2});
        }
        Files.deleteIfExists(path);
        return null;
    }

    protected Iterable readKeyPairs(SessionContext sessionContext, Path path, OpenOption ... openOptionArray) {
        PathResource pathResource = new PathResource(path, openOptionArray);
        try (InputStream inputStream = pathResource.openInputStream();){
            Iterable iterable = this.doReadKeyPairs(sessionContext, pathResource, inputStream);
            return iterable;
        }
    }

    protected Iterable doReadKeyPairs(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream) {
        return SecurityUtils.loadKeyPairIdentities(sessionContext, namedResource, inputStream, null);
    }

    protected void writeKeyPair(KeyPair keyPair, Path path) {
        Objects.requireNonNull(keyPair, "No host key");
        if (!Files.exists(path, new LinkOption[0]) || this.isOverwriteAllowed()) {
            Files.newOutputStream(path, new OpenOption[0]).close();
            if (this.enforceFilePermissions) {
                this.setFilePermissions(path);
            }
            try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                this.doWriteKeyPair(new PathResource(path), keyPair, outputStream);
            }
            catch (Exception exception) {
                this.error("writeKeyPair({}) failed ({}) to write {} host key : {}", path, exception.getClass().getSimpleName(), KeyUtils.getKeyType(keyPair), exception.getMessage(), exception);
            }
        } else {
            this.log.warn("Overwriting host key ({}) is disabled: using throwaway {} key: {}", new Object[]{path, KeyUtils.getKeyType(keyPair), KeyUtils.getFingerPrint(keyPair.getPublic())});
        }
    }

    protected void setFilePermissions(Path path) {
        Exception exception = null;
        if (OsUtils.isWin32()) {
            AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            UserPrincipal userPrincipal = Files.getOwner(path, new LinkOption[0]);
            if (aclFileAttributeView != null && userPrincipal != null) {
                try {
                    ArrayList<AclEntry> arrayList = new ArrayList<AclEntry>();
                    for (AclEntry aclEntry : aclFileAttributeView.getAcl()) {
                        if (userPrincipal.equals(aclEntry.principal()) || AclEntryType.ALLOW.equals((Object)aclEntry.type())) continue;
                        arrayList.add(aclEntry);
                    }
                    arrayList.add(AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(userPrincipal).setPermissions(EnumSet.allOf(AclEntryPermission.class)).build());
                    aclFileAttributeView.setAcl(arrayList);
                    return;
                }
                catch (IOException | SecurityException exception2) {
                    exception = exception2;
                }
            }
        } else {
            File file = path.toFile();
            if (!file.setExecutable(false)) {
                this.log.debug("Host key file {}: cannot set non-executable", (Object)path);
            }
            boolean bl2 = file.setWritable(false, false) && file.setWritable(true, true);
            boolean bl3 = bl2 = file.setReadable(false, false) && file.setReadable(true, true) && bl2;
            if (bl2) {
                return;
            }
        }
        this.log.warn("Host key file {}: cannot set file permissions correctly (readable and writeable only by owner)", (Object)path, (Object)exception);
    }

    protected abstract void doWriteKeyPair(NamedResource var1, KeyPair var2, OutputStream var3);

    protected KeyPair generateKeyPair(String string) {
        KeyPairGenerator keyPairGenerator = SecurityUtils.getKeyPairGenerator(string);
        if (this.keySpec != null) {
            keyPairGenerator.initialize(this.keySpec);
            this.log.info("generateKeyPair({}) generating host key - spec={}", (Object)string, (Object)this.keySpec.getClass().getSimpleName());
        } else if (DEFAULT_ALGORITHM.equals(string)) {
            ECCurves eCCurves;
            if (this.keySize == 0) {
                int n2 = ECCurves.SORTED_KEY_SIZE.size();
                eCCurves = (ECCurves)ECCurves.SORTED_KEY_SIZE.get(n2 - 1);
            } else {
                eCCurves = ECCurves.fromCurveSize(this.keySize);
                if (eCCurves == null) {
                    throw new InvalidKeyException("No match found for curve with key size=" + this.keySize);
                }
            }
            keyPairGenerator.initialize(eCCurves.getParameters());
            this.log.info("generateKeyPair({}) generating host key={}", (Object)string, (Object)eCCurves);
        } else if (this.keySize != 0) {
            keyPairGenerator.initialize(this.keySize);
            this.log.info("generateKeyPair({}) generating host key - size={}", (Object)string, (Object)this.keySize);
        } else {
            this.log.info("generateKeyPair({}) generating host key", (Object)string);
        }
        return keyPairGenerator.generateKeyPair();
    }
}

