/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.kex.Moduli$DhGroup;

public final class Moduli {
    public static final String INTERNAL_MODULI_RESPATH = "/org/apache/sshd/moduli";
    public static final int MODULI_TYPE_SAFE = 2;
    public static final int MODULI_TESTS_COMPOSITE = 1;
    private static final AtomicReference INTERNAL_MODULI_HOLDER = new AtomicReference();

    private Moduli() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static Map.Entry clearInternalModuliCache() {
        return INTERNAL_MODULI_HOLDER.getAndSet(null);
    }

    public static List loadInternalModuli(URL uRL) {
        String string;
        if (uRL == null) {
            throw new FileNotFoundException("No internal moduli resource specified");
        }
        String string2 = uRL.toExternalForm();
        Map.Entry entry = (Map.Entry)INTERNAL_MODULI_HOLDER.get();
        String string3 = string = entry == null ? null : (String)entry.getKey();
        if (Objects.equals(string, string2)) {
            return (List)entry.getValue();
        }
        List list = Moduli.parseModuli(uRL);
        list = GenericUtils.isEmpty(list) ? Collections.emptyList() : Collections.unmodifiableList(list);
        INTERNAL_MODULI_HOLDER.set(new AbstractMap.SimpleImmutableEntry(string2, list));
        return list;
    }

    public static List parseModuli(URL uRL) {
        try (InputStream inputStream = uRL.openStream();){
            List list = Moduli.parseModuli(inputStream);
            return list;
        }
    }

    public static List parseModuli(InputStream inputStream) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            List list = Moduli.parseModuli(inputStreamReader);
            return list;
        }
    }

    public static List parseModuli(Reader reader) {
        if (reader instanceof BufferedReader) {
            return Moduli.parseModuli((BufferedReader)reader);
        }
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            List list = Moduli.parseModuli(bufferedReader);
            return list;
        }
    }

    public static List parseModuli(BufferedReader bufferedReader) {
        ArrayList<Moduli$DhGroup> arrayList = new ArrayList<Moduli$DhGroup>();
        String string = bufferedReader.readLine();
        while (string != null) {
            int n2;
            int n3;
            int n4;
            String[] stringArray;
            if (!(string = string.trim()).isEmpty() && string.charAt(0) != '#' && (stringArray = string.split("\\s+")).length == 7 && (n4 = Integer.parseInt(stringArray[1])) == 2 && ((n3 = Integer.parseInt(stringArray[2])) & 1) == 0 && (n3 & 0xFFFFFFFE) != 0 && (n2 = Integer.parseInt(stringArray[3])) != 0) {
                Moduli$DhGroup moduli$DhGroup = new Moduli$DhGroup(Integer.parseInt(stringArray[4]) + 1, new BigInteger(stringArray[5], 16), new BigInteger(stringArray[6], 16));
                arrayList.add(moduli$DhGroup);
            }
            string = bufferedReader.readLine();
        }
        return arrayList;
    }
}

