/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.kex.AbstractDHServerKeyExchange;
import org.apache.sshd.server.kex.DHGServer$1;
import org.apache.sshd.server.session.ServerSession;

public class DHGServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGServer(DHFactory dHFactory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(dHFactory, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(DHFactory dHFactory) {
        return new DHGServer$1(dHFactory);
    }

    @Override
    public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super.init(byArray, byArray2, byArray3, byArray4);
        this.dh = this.factory.create(new Object[0]);
        this.hash = this.dh.getHash();
        this.hash.init();
        this.setF(this.dh.getE());
    }

    @Override
    public boolean next(int n2, Buffer buffer) {
        ServerSession serverSession = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", new Object[]{this, serverSession, KeyExchange.getSimpleKexOpcodeName(n2)});
        }
        if (n2 != 30) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_INIT, got " + KeyExchange.getSimpleKexOpcodeName(n2));
        }
        byte[] byArray = this.updateE(buffer);
        this.dh.setF(byArray);
        this.k = this.dh.getK();
        KeyPair keyPair = Objects.requireNonNull(serverSession.getHostKey(), "No server key pair available");
        String string = serverSession.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(serverSession.getSignatureFactories(), string)), "Unknown negotiated server keys: %s", (Object)string);
        signature.initSigner(serverSession, keyPair.getPrivate());
        buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(keyPair.getPublic());
        byte[] byArray2 = buffer.getCompactData();
        buffer.clear();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(byArray2);
        this.dh.putE(buffer, byArray);
        byte[] byArray3 = this.getF();
        this.dh.putF(buffer, byArray3);
        buffer.putMPInt(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        signature.update(serverSession, this.h);
        buffer.clear();
        buffer.putString(signature.getSshAlgorithmName(string));
        byte[] byArray4 = signature.sign(serverSession);
        buffer.putBytes(byArray4);
        byte[] byArray5 = buffer.getCompactData();
        if (this.log.isTraceEnabled()) {
            this.log.trace("next({})[{}][K_S]:  {}", new Object[]{this, serverSession, BufferUtils.toHex(byArray2)});
            this.log.trace("next({})[{}][f]:    {}", new Object[]{this, serverSession, BufferUtils.toHex(byArray3)});
            this.log.trace("next({})[{}][sigH]: {}", new Object[]{this, serverSession, BufferUtils.toHex(byArray5)});
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] Send SSH_MSG_KEXDH_REPLY", (Object)this, (Object)serverSession);
        }
        buffer = serverSession.prepareBuffer((byte)31, BufferUtils.clear(buffer));
        buffer.putBytes(byArray2);
        this.dh.putF(buffer, byArray3);
        buffer.putBytes(byArray5);
        serverSession.writePacket(buffer);
        return true;
    }
}

