/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.DHG;
import org.apache.sshd.common.kex.DHGroupData;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.kex.AbstractDHServerKeyExchange;
import org.apache.sshd.server.kex.DHGEXServer$1;
import org.apache.sshd.server.kex.Moduli;
import org.apache.sshd.server.kex.Moduli$DhGroup;
import org.apache.sshd.server.session.ServerSession;

public class DHGEXServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected DHG dh;
    protected int min;
    protected int prf;
    protected int max;
    protected byte expected;
    protected boolean oldRequest;

    protected DHGEXServer(DHFactory dHFactory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(dHFactory, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(DHFactory dHFactory) {
        return new DHGEXServer$1(dHFactory);
    }

    @Override
    public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super.init(byArray, byArray2, byArray3, byArray4);
        this.expected = (byte)34;
    }

    @Override
    public boolean next(int n2, Buffer buffer) {
        ServerSession serverSession = this.getServerSession();
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("next({})[{}] process command={} (expected={})", new Object[]{this, serverSession, KeyExchange.getGroupKexOpcodeName(n2), KeyExchange.getGroupKexOpcodeName(this.expected)});
        }
        if (n2 == 30 && this.expected == 34) {
            this.oldRequest = true;
            this.min = CoreModuleProperties.PROP_DHGEX_SERVER_MIN_KEY.get(serverSession).orElse(SecurityUtils.getMinDHGroupExchangeKeySize());
            this.prf = buffer.getInt();
            this.max = CoreModuleProperties.PROP_DHGEX_SERVER_MAX_KEY.get(serverSession).orElse(SecurityUtils.getMaxDHGroupExchangeKeySize());
            if (this.max < this.min || this.prf < this.min || this.max < this.prf) {
                throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
            }
            this.dh = this.chooseDH(this.min, this.prf, this.max);
            this.setF(this.dh.getE());
            BigInteger bigInteger = this.dh.getP();
            this.validateFValue(bigInteger);
            this.hash = this.dh.getHash();
            this.hash.init();
            if (bl2) {
                this.log.debug("next({})[{}] send (old request) SSH_MSG_KEX_DH_GEX_GROUP - min={}, prf={}, max={}", new Object[]{this, serverSession, this.min, this.prf, this.max});
            }
            buffer = serverSession.createBuffer((byte)31);
            buffer.putMPInt(bigInteger);
            buffer.putMPInt(this.dh.getG());
            serverSession.writePacket(buffer);
            this.expected = (byte)32;
            return false;
        }
        if (n2 == 34 && this.expected == 34) {
            this.min = buffer.getInt();
            this.prf = buffer.getInt();
            this.max = buffer.getInt();
            if (this.prf < this.min || this.max < this.prf) {
                throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
            }
            this.dh = this.chooseDH(this.min, this.prf, this.max);
            this.setF(this.dh.getE());
            BigInteger bigInteger = this.dh.getP();
            this.validateFValue(bigInteger);
            this.hash = this.dh.getHash();
            this.hash.init();
            if (bl2) {
                this.log.debug("next({})[{}] Send SSH_MSG_KEX_DH_GEX_GROUP - min={}, prf={}, max={}", new Object[]{this, serverSession, this.min, this.prf, this.max});
            }
            buffer = serverSession.createBuffer((byte)31);
            buffer.putMPInt(bigInteger);
            buffer.putMPInt(this.dh.getG());
            serverSession.writePacket(buffer);
            this.expected = (byte)32;
            return false;
        }
        if (n2 != this.expected) {
            throw new SshException(3, "Protocol error: expected packet " + KeyExchange.getGroupKexOpcodeName(this.expected) + ", got " + KeyExchange.getGroupKexOpcodeName(n2));
        }
        if (n2 == 32) {
            byte[] byArray = this.updateE(buffer.getMPIntAsBytes());
            BigInteger bigInteger = this.dh.getP();
            this.validateEValue(bigInteger);
            this.dh.setF(byArray);
            this.k = this.dh.getK();
            KeyPair keyPair = Objects.requireNonNull(serverSession.getHostKey(), "No server key pair available");
            String string = serverSession.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
            Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(serverSession.getSignatureFactories(), string)), "Unknown negotiated server keys: %s", (Object)string);
            signature.initSigner(serverSession, keyPair.getPrivate());
            buffer = new ByteArrayBuffer();
            buffer.putRawPublicKey(keyPair.getPublic());
            byte[] byArray2 = buffer.getCompactData();
            buffer.clear();
            buffer.putBytes(this.v_c);
            buffer.putBytes(this.v_s);
            buffer.putBytes(this.i_c);
            buffer.putBytes(this.i_s);
            buffer.putBytes(byArray2);
            if (this.oldRequest) {
                buffer.putInt(this.prf);
            } else {
                buffer.putInt(this.min);
                buffer.putInt(this.prf);
                buffer.putInt(this.max);
            }
            buffer.putMPInt(bigInteger);
            buffer.putMPInt(this.dh.getG());
            buffer.putMPInt(byArray);
            byte[] byArray3 = this.getF();
            buffer.putMPInt(byArray3);
            buffer.putMPInt(this.k);
            this.hash.update(buffer.array(), 0, buffer.available());
            this.h = this.hash.digest();
            signature.update(serverSession, this.h);
            buffer.clear();
            buffer.putString(string);
            byte[] byArray4 = signature.sign(serverSession);
            buffer.putBytes(byArray4);
            byte[] byArray5 = buffer.getCompactData();
            if (this.log.isTraceEnabled()) {
                this.log.trace("next({})[{}][K_S]:  {}", new Object[]{this, serverSession, BufferUtils.toHex(byArray2)});
                this.log.trace("next({})[{}][f]:    {}", new Object[]{this, serverSession, BufferUtils.toHex(byArray3)});
                this.log.trace("next({})[{}][sigH]: {}", new Object[]{this, serverSession, BufferUtils.toHex(byArray5)});
            }
            if (bl2) {
                this.log.debug("next({})[{}] Send SSH_MSG_KEX_DH_GEX_REPLY - old={}, min={}, prf={}, max={}", new Object[]{this, serverSession, this.oldRequest, this.min, this.prf, this.max});
            }
            buffer = serverSession.prepareBuffer((byte)33, BufferUtils.clear(buffer));
            buffer.putBytes(byArray2);
            buffer.putBytes(byArray3);
            buffer.putBytes(byArray5);
            serverSession.writePacket(buffer);
            return true;
        }
        return false;
    }

    protected DHG chooseDH(int n2, int n3, int n4) {
        List list;
        ServerSession serverSession = this.getServerSession();
        List list2 = this.selectModuliGroups(serverSession, n2, n3, n4, list = this.loadModuliGroups(serverSession));
        if (GenericUtils.isEmpty(list2)) {
            if (!((Boolean)CoreModuleProperties.ALLOW_DHG1_KEX_FALLBACK.getRequired(serverSession)).booleanValue()) {
                this.log.error("chooseDH({})[{}][prf={}, min={}, max={}] No suitable primes found - failing", new Object[]{this, serverSession, n3, n2, n4});
                throw new SshException(3, "No suitable primes found for DH group exchange");
            }
            this.log.warn("chooseDH({})[{}][prf={}, min={}, max={}] No suitable primes found - defaulting to DHG1", new Object[]{this, serverSession, n3, n2, n4});
            return this.getDH(new BigInteger(DHGroupData.getP1()), new BigInteger(DHGroupData.getG()));
        }
        FactoryManager factoryManager = Objects.requireNonNull(serverSession.getFactoryManager(), "No factory manager");
        Factory factory = Objects.requireNonNull(factoryManager.getRandomFactory(), "No random factory");
        Random random = Objects.requireNonNull((Random)factory.create(), "No random generator");
        int n5 = random.random(list2.size());
        Moduli$DhGroup moduli$DhGroup = (Moduli$DhGroup)list2.get(n5);
        if (this.log.isTraceEnabled()) {
            this.log.trace("chooseDH({})[{}][prf={}, min={}, max={}] selected {}", new Object[]{this, serverSession, n3, n2, n4, moduli$DhGroup});
        }
        return this.getDH(moduli$DhGroup.getP(), moduli$DhGroup.getG());
    }

    protected List selectModuliGroups(ServerSession serverSession, int n2, int n3, int n4, List list) {
        int n5 = SecurityUtils.getMaxDHGroupExchangeKeySize();
        int n6 = SecurityUtils.getMinDHGroupExchangeKeySize();
        n2 = Math.max(n2, n6);
        n3 = Math.max(n3, n6);
        n3 = Math.min(n3, n5);
        n4 = Math.min(n4, n5);
        ArrayList<Moduli$DhGroup> arrayList = new ArrayList<Moduli$DhGroup>();
        int n7 = 0;
        boolean bl2 = this.log.isTraceEnabled();
        for (Moduli$DhGroup moduli$DhGroup : list) {
            int n8 = moduli$DhGroup.getSize();
            if (n8 < n2 || n8 > n4) {
                if (!bl2) continue;
                this.log.trace("selectModuliGroups({})[{}] - skip group={} - size not in range [{}-{}]", new Object[]{this, serverSession, moduli$DhGroup, n2, n4});
                continue;
            }
            if (n8 > n3 && n8 < n7 || n8 > n7 && n7 < n3) {
                n7 = n8;
                if (bl2) {
                    this.log.trace("selectModuliGroups({})[{}][prf={}, min={}, max={}] new best size={} from group={}", new Object[]{this, serverSession, n3, n2, n4, n7, moduli$DhGroup});
                }
                arrayList.clear();
            }
            if (n8 != n7) continue;
            if (bl2) {
                this.log.trace("selectModuliGroups({})[{}][prf={}, min={}, max={}] selected {}", new Object[]{this, serverSession, n3, n2, n4, moduli$DhGroup});
            }
            arrayList.add(moduli$DhGroup);
        }
        return arrayList;
    }

    protected List loadModuliGroups(ServerSession serverSession) {
        URL uRL;
        String string = (String)CoreModuleProperties.MODULI_URL.getOrNull(serverSession);
        List list = null;
        if (!GenericUtils.isEmpty(string)) {
            try {
                uRL = new URL(string);
                list = Moduli.parseModuli(uRL);
            }
            catch (IOException iOException) {
                this.log.warn("loadModuliGroups({})[{}] Error ({}) loading external moduli from {}: {}", new Object[]{this, serverSession, iOException.getClass().getSimpleName(), string, iOException.getMessage()});
            }
        }
        if (list == null) {
            string = "/org/apache/sshd/moduli";
            try {
                uRL = this.getClass().getResource(string);
                if (uRL == null) {
                    throw new FileNotFoundException("Missing internal moduli file");
                }
                string = uRL.toExternalForm();
                list = Moduli.loadInternalModuli(uRL);
            }
            catch (IOException iOException) {
                this.log.warn("loadModuliGroups({})[{}] Error ({}) loading internal moduli from {}: {}", new Object[]{this, serverSession, iOException.getClass().getSimpleName(), string, iOException.getMessage()});
                throw iOException;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadModuliGroups({})[{}] Loaded {} moduli groups from {}", new Object[]{this, serverSession, GenericUtils.size(list), string});
        }
        return list;
    }

    protected DHG getDH(BigInteger bigInteger, BigInteger bigInteger2) {
        return (DHG)this.factory.create(bigInteger, bigInteger2);
    }
}

