/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.jaas;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class JaasPasswordAuthenticator
extends AbstractLoggingBean
implements PasswordAuthenticator {
    private String domain;

    public JaasPasswordAuthenticator() {
        this((String)null);
    }

    public JaasPasswordAuthenticator(String string) {
        this.domain = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    @Override
    public boolean authenticate(String string, String string2, ServerSession serverSession) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.getDomain(), subject, callbackArray -> {
                for (Callback callback : callbackArray) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(string);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(string2.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
            loginContext.login();
            loginContext.logout();
            return true;
        }
        catch (Exception exception) {
            this.warn("authenticate({}) failed ({}) to authenticate user={}: {}", serverSession, exception.getClass().getSimpleName(), string, exception.getMessage(), exception);
            return false;
        }
    }
}

