/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.global;

import java.util.Objects;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.functors.Int2IntFunction;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class TcpipForwardHandler
extends AbstractConnectionServiceRequestHandler {
    public static final String REQUEST = "tcpip-forward";
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    public static final TcpipForwardHandler INSTANCE = new TcpipForwardHandler();

    @Override
    public RequestHandler$Result process(ConnectionService connectionService, String string, boolean bl2, Buffer buffer) {
        if (!REQUEST.equals(string)) {
            return super.process(connectionService, string, bl2, buffer);
        }
        String string2 = buffer.getString();
        int n2 = buffer.getInt();
        SshdSocketAddress sshdSocketAddress = new SshdSocketAddress(string2, n2);
        Forwarder forwarder = Objects.requireNonNull(connectionService.getForwarder(), "No TCP/IP forwarder");
        SshdSocketAddress sshdSocketAddress2 = forwarder.localPortForwardingRequested(sshdSocketAddress);
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[{}][want-reply-{}] {} => {}", new Object[]{connectionService, string, bl2, sshdSocketAddress, sshdSocketAddress2});
        }
        if (sshdSocketAddress2 == null) {
            return RequestHandler$Result.ReplyFailure;
        }
        n2 = sshdSocketAddress2.getPort();
        if (bl2) {
            Session session = connectionService.getSession();
            buffer = session.createBuffer((byte)81, 4);
            buffer.putUInt(n2);
            session.writePacket(buffer);
        }
        return RequestHandler$Result.Replied;
    }
}

