/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.global;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.global.AbstractOpenSshHostKeysHandler;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.apache.sshd.server.global.OpenSshHostKeysHandler$1;
import org.apache.sshd.server.session.ServerSession;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler
implements SignatureFactoriesManager {
    public static final String REQUEST = "hostkeys-prove-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler$1();
    private List factories;

    public OpenSshHostKeysHandler() {
        super(REQUEST);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser bufferPublicKeyParser) {
        super(REQUEST, bufferPublicKeyParser);
    }

    @Override
    public List getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List list) {
        this.factories = list;
    }

    @Override
    protected RequestHandler$Result handleHostKeys(Session session, Collection collection, boolean bl2, Buffer buffer) {
        ValidateUtils.checkTrue(bl2, "No reply required for host keys of %s", (Object)session);
        Collection collection2 = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, session), "No signature factories available for host keys of session=%s", session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys - factories={}", new Object[]{session, bl2, GenericUtils.size(collection), NamedResource.getNames(collection2)});
        }
        buffer = session.createBuffer((byte)81);
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byte[] byArray = session.getSessionId();
        KeyPairProvider keyPairProvider = Objects.requireNonNull(((ServerSession)session).getKeyPairProvider(), "No server keys provider");
        for (PublicKey publicKey : collection) {
            KeyPair keyPair;
            String string = KeyUtils.getKeyType(publicKey);
            Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(collection2, string)), "No signer could be located for key type=%s", (Object)string);
            try {
                keyPair = (KeyPair)ValidateUtils.checkNotNull((Object)keyPairProvider.loadKey(session, string), "No key of type=%s available", (Object)string);
            }
            catch (Error error) {
                this.warn("handleHostKeys({}) failed ({}) to load key of type={}: {}", session, error.getClass().getSimpleName(), string, error.getMessage(), error);
                throw new RuntimeSshException(error);
            }
            signature.initSigner(session, keyPair.getPrivate());
            byteArrayBuffer.clear();
            byteArrayBuffer.putString(REQUEST);
            byteArrayBuffer.putBytes(byArray);
            byteArrayBuffer.putPublicKey(publicKey);
            byte[] byArray2 = byteArrayBuffer.getCompactData();
            signature.update(session, byArray2);
            byte[] byArray3 = signature.sign(session);
            buffer.putBytes(byArray3);
        }
        session.writePacket(buffer);
        return RequestHandler$Result.Replied;
    }
}

