/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.exception.SshChannelOpenException;
import org.apache.sshd.common.forward.ChannelToPortHandler;
import org.apache.sshd.common.forward.ForwardingTunnelEndpointsProvider;
import org.apache.sshd.common.forward.PortForwardingInformationProvider;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter$Type;
import org.apache.sshd.server.forward.TcpipServerChannel$1;
import org.apache.sshd.server.forward.TcpipServerChannel$2;
import org.apache.sshd.server.forward.TcpipServerChannel$PortIoHandler;
import org.slf4j.Logger;

public class TcpipServerChannel
extends AbstractServerChannel
implements ForwardingTunnelEndpointsProvider {
    private final TcpForwardingFilter$Type type;
    private IoConnector connector;
    private ChannelToPortHandler port;
    private ChannelAsyncOutputStream out;
    private SshdSocketAddress tunnelEntrance;
    private SshdSocketAddress tunnelExit;
    private SshdSocketAddress originatorAddress;
    private SocketAddress localAddress;

    public TcpipServerChannel(TcpForwardingFilter$Type tcpForwardingFilter$Type, CloseableExecutorService closeableExecutorService) {
        super("", Collections.emptyList(), closeableExecutorService);
        this.type = Objects.requireNonNull(tcpForwardingFilter$Type, "No channel type specified");
    }

    public TcpForwardingFilter$Type getTcpipChannelType() {
        return this.type;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(SocketAddress socketAddress) {
        this.localAddress = socketAddress;
    }

    @Override
    public SshdSocketAddress getTunnelEntrance() {
        return this.tunnelEntrance;
    }

    @Override
    public SshdSocketAddress getTunnelExit() {
        return this.tunnelExit;
    }

    public SshdSocketAddress getOriginatorAddress() {
        return this.originatorAddress;
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) {
        super.handleWindowAdjust(buffer);
        if (this.out != null) {
            this.out.onWindowExpanded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture defaultOpenFuture;
        FactoryManager factoryManager;
        SshdSocketAddress sshdSocketAddress;
        block11: {
            PortForwardingInformationProvider portForwardingInformationProvider;
            String string = buffer.getString();
            int n2 = buffer.getInt();
            String string2 = buffer.getString();
            int n3 = buffer.getInt();
            boolean bl2 = this.log.isDebugEnabled();
            if (bl2) {
                this.log.debug("doInit({}) Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", new Object[]{this, string, n2, string2, n3});
            }
            TcpForwardingFilter$Type tcpForwardingFilter$Type = this.getTcpipChannelType();
            switch (this.type) {
                case Direct: {
                    sshdSocketAddress = new SshdSocketAddress(string, n2);
                    break;
                }
                case Forwarded: {
                    portForwardingInformationProvider = this.service.getForwarder();
                    sshdSocketAddress = portForwardingInformationProvider.getForwardedPort(n2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown server channel type: " + tcpForwardingFilter$Type);
                }
            }
            this.originatorAddress = new SshdSocketAddress(string2, n3);
            this.tunnelEntrance = new SshdSocketAddress(string, n2);
            this.tunnelExit = sshdSocketAddress;
            portForwardingInformationProvider = this.getSession();
            factoryManager = Objects.requireNonNull(portForwardingInformationProvider.getFactoryManager(), "No factory manager");
            TcpForwardingFilter tcpForwardingFilter = factoryManager.getTcpForwardingFilter();
            defaultOpenFuture = new DefaultOpenFuture(this, this);
            try {
                if (sshdSocketAddress != null && tcpForwardingFilter != null && tcpForwardingFilter.canConnect(tcpForwardingFilter$Type, sshdSocketAddress, (Session)portForwardingInformationProvider)) break block11;
                if (bl2) {
                    this.log.debug("doInit({})[{}][haveFilter={}] filtered out {}", new Object[]{this, this.type, tcpForwardingFilter != null, sshdSocketAddress});
                }
                try {
                    defaultOpenFuture.setException(new SshChannelOpenException(this.getChannelId(), 1, "Connection denied"));
                }
                finally {
                    super.close(true);
                }
                return defaultOpenFuture;
            }
            catch (Error error) {
                this.warn("doInit({})[{}] failed ({}) to consult forwarding filter: {}", portForwardingInformationProvider, tcpForwardingFilter$Type, error.getClass().getSimpleName(), error.getMessage(), error);
                throw new RuntimeSshException(error);
            }
        }
        this.out = new TcpipServerChannel$1(this, this, 94);
        IoServiceFactory ioServiceFactory = factoryManager.getIoServiceFactory();
        this.connector = ioServiceFactory.createConnector(new TcpipServerChannel$PortIoHandler(this));
        IoConnectFuture ioConnectFuture2 = this.connector.connect(sshdSocketAddress.toInetSocketAddress(), null, this.getLocalAddress());
        ioConnectFuture2.addListener(ioConnectFuture -> this.handleChannelConnectResult(defaultOpenFuture, (IoConnectFuture)ioConnectFuture));
        return defaultOpenFuture;
    }

    @Override
    protected boolean mayWrite() {
        return !this.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelConnectResult(OpenFuture openFuture, IoConnectFuture ioConnectFuture) {
        try {
            if (ioConnectFuture.isConnected()) {
                this.handleChannelOpenSuccess(openFuture, ioConnectFuture.getSession());
                return;
            }
            Throwable throwable = ExceptionUtils.peelException(ioConnectFuture.getException());
            if (throwable != null) {
                this.handleChannelOpenFailure(openFuture, throwable);
            }
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = ExceptionUtils.peelException(runtimeException);
            this.signalChannelOpenFailure(throwable);
            try {
                openFuture.setException(throwable);
            }
            finally {
                this.notifyStateChanged(throwable.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChannelOpenSuccess(OpenFuture openFuture, IoSession ioSession) {
        this.port = this.createChannelToPortHandler(ioSession);
        String string = ioSession.toString();
        try {
            this.signalChannelOpenSuccess();
            openFuture.setOpened();
            if (openFuture.isCanceled()) {
                this.close(false).addListener(closeFuture -> openFuture.getCancellation().setCanceled());
            } else {
                ioSession.resumeRead();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            string = throwable2.getClass().getSimpleName();
            this.signalChannelOpenFailure(throwable2);
            openFuture.setException(throwable2);
        }
        finally {
            this.notifyStateChanged(string);
        }
    }

    protected void handleChannelOpenFailure(OpenFuture openFuture, Throwable throwable) {
        this.signalChannelOpenFailure(throwable);
        this.notifyStateChanged(throwable.getClass().getSimpleName());
        try {
            if (throwable instanceof ConnectException) {
                openFuture.setException(new SshChannelOpenException(this.getChannelId(), 2, throwable.getMessage(), throwable));
            } else {
                openFuture.setException(throwable);
            }
        }
        finally {
            this.close(true);
        }
    }

    @Override
    public void handleEof() {
        super.handleEof();
        if (this.port != null) {
            this.port.handleEof();
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.out).close(super.getInnerCloseable()).close(new TcpipServerChannel$2(this)).build();
    }

    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        this.port.sendToPort((byte)94, byArray, n2, l2);
    }

    @Override
    protected void doWriteExtendedData(byte[] byArray, int n2, long l2) {
        throw new UnsupportedOperationException(this.getTcpipChannelType() + " Tcpip channel does not support extended data");
    }

    protected ChannelToPortHandler createChannelToPortHandler(IoSession ioSession) {
        return new ChannelToPortHandler(ioSession, this);
    }

    static /* synthetic */ IoWriteFuture access$000(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.sendEof();
    }

    static /* synthetic */ IoConnector access$100(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.connector;
    }

    static /* synthetic */ Logger access$200(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.log;
    }

    static /* synthetic */ Logger access$300(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.log;
    }

    static /* synthetic */ Logger access$400(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.log;
    }

    static /* synthetic */ Logger access$500(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.log;
    }

    static /* synthetic */ ChannelAsyncOutputStream access$600(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.out;
    }

    static /* synthetic */ Logger access$700(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.log;
    }

    static /* synthetic */ Logger access$800(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.log;
    }

    static /* synthetic */ Logger access$900(TcpipServerChannel tcpipServerChannel) {
        return tcpipServerChannel.log;
    }
}

