/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter$Type;

public class StaticDecisionForwardingFilter
extends AbstractLoggingBean
implements ForwardingFilter {
    private final boolean acceptance;

    public StaticDecisionForwardingFilter(boolean bl2) {
        this.acceptance = bl2;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public boolean canForwardAgent(Session session, String string) {
        return this.checkAcceptance(string, session, SshdSocketAddress.LOCALHOST_ADDRESS);
    }

    @Override
    public boolean canForwardX11(Session session, String string) {
        return this.checkAcceptance(string, session, SshdSocketAddress.LOCALHOST_ADDRESS);
    }

    @Override
    public boolean canListen(SshdSocketAddress sshdSocketAddress, Session session) {
        return this.checkAcceptance("tcpip-forward", session, sshdSocketAddress);
    }

    @Override
    public boolean canConnect(TcpForwardingFilter$Type tcpForwardingFilter$Type, SshdSocketAddress sshdSocketAddress, Session session) {
        return this.checkAcceptance(tcpForwardingFilter$Type.getName(), session, sshdSocketAddress);
    }

    protected boolean checkAcceptance(String string, Session session, SshdSocketAddress sshdSocketAddress) {
        boolean bl2 = this.isAccepted();
        if (this.log.isDebugEnabled()) {
            this.log.debug("checkAcceptance({})[{}] acceptance for target={} is {}", new Object[]{string, session, sshdSocketAddress, bl2});
        }
        return bl2;
    }
}

