/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.IdentityUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.SshServer;

public final class ServerIdentity {
    public static final String ID_FILE_PREFIX = "ssh_host_";
    public static final String ID_FILE_SUFFIX = "_key";
    public static final String HOST_KEY_CONFIG_PROP = "HostKey";
    public static final String HOST_CERT_CONFIG_PROP = "HostCertificate";
    public static final Function ID_GENERATOR = ServerIdentity::getIdentityFileName;

    private ServerIdentity() {
        throw new UnsupportedOperationException("No instance");
    }

    public static SshServer setKeyPairProvider(SshServer sshServer, Properties properties, boolean bl2) {
        KeyPairProvider keyPairProvider = ServerIdentity.loadKeyPairProvider(properties, bl2, IoUtils.getLinkOptions(true));
        if (keyPairProvider != null) {
            sshServer.setKeyPairProvider(keyPairProvider);
        }
        return sshServer;
    }

    public static KeyPairProvider loadKeyPairProvider(Properties properties, boolean bl2, LinkOption ... linkOptionArray) {
        Map map = ServerIdentity.loadIdentities(properties, linkOptionArray);
        return IdentityUtils.createKeyPairProvider(map, bl2);
    }

    public static Map loadIdentities(Properties properties, LinkOption ... linkOptionArray) {
        Map map = ServerIdentity.findIdentities(properties, linkOptionArray);
        return IdentityUtils.loadIdentities(null, map, null, IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static Map findIdentities(Properties properties, LinkOption ... linkOptionArray) {
        return ServerIdentity.getLocations(HOST_KEY_CONFIG_PROP, properties, linkOptionArray);
    }

    public static Map findCertificates(Properties properties, LinkOption ... linkOptionArray) {
        return ServerIdentity.getLocations(HOST_CERT_CONFIG_PROP, properties, linkOptionArray);
    }

    private static Map getLocations(String string, Properties properties, LinkOption ... linkOptionArray) {
        if (MapEntryUtils.isEmpty(properties)) {
            return Collections.emptyMap();
        }
        String string2 = properties.getProperty(string);
        Object[] objectArray = GenericUtils.split(string2, ',');
        if (GenericUtils.isEmpty(objectArray)) {
            return Collections.emptyMap();
        }
        TreeMap<Object, Path> treeMap = new TreeMap<Object, Path>(String.CASE_INSENSITIVE_ORDER);
        for (Object object : objectArray) {
            Path path;
            File file = new File((String)object);
            Path path2 = file.toPath();
            if (!Files.exists(path2, linkOptionArray)) continue;
            Object object2 = ServerIdentity.getIdentityType(path2.getFileName().toString());
            if (GenericUtils.isEmpty((CharSequence)object2)) {
                object2 = object;
            }
            ValidateUtils.checkTrue((path = treeMap.put(object2, path2)) == null, "Multiple mappings for type=%s", object2);
        }
        return treeMap;
    }

    public static String getIdentityType(String string) {
        if (GenericUtils.isEmpty(string) || string.length() <= ID_FILE_PREFIX.length() + ID_FILE_SUFFIX.length() || !string.startsWith(ID_FILE_PREFIX) || !string.endsWith(ID_FILE_SUFFIX)) {
            return null;
        }
        return string.substring(ID_FILE_PREFIX.length(), string.length() - ID_FILE_SUFFIX.length());
    }

    public static String getIdentityFileName(NamedResource namedResource) {
        return ServerIdentity.getIdentityFileName(namedResource == null ? null : namedResource.getName());
    }

    public static String getIdentityFileName(String string) {
        return IdentityUtils.getIdentityFileName(ID_FILE_PREFIX, string, ID_FILE_SUFFIX);
    }
}

