/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.auth.UsernameHolder;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.config.keys.AuthorizedKeysAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class DefaultAuthorizedKeysAuthenticator
extends AuthorizedKeysAuthenticator
implements UsernameHolder {
    public static final DefaultAuthorizedKeysAuthenticator INSTANCE = new DefaultAuthorizedKeysAuthenticator(true);
    private final boolean strict;
    private final String user;

    public DefaultAuthorizedKeysAuthenticator(boolean bl2) {
        this(OsUtils.getCurrentUser(), bl2);
    }

    public DefaultAuthorizedKeysAuthenticator(String string, boolean bl2) {
        this(string, DefaultAuthorizedKeysAuthenticator.getDefaultAuthorizedKeysFile(), bl2, new LinkOption[0]);
    }

    public DefaultAuthorizedKeysAuthenticator(Path path, boolean bl2, LinkOption ... linkOptionArray) {
        this(OsUtils.getCurrentUser(), path, bl2, linkOptionArray);
    }

    public DefaultAuthorizedKeysAuthenticator(String string, Path path, boolean bl2, LinkOption ... linkOptionArray) {
        super(path, linkOptionArray);
        this.user = ValidateUtils.checkNotNullAndNotEmpty(string, "No username provided");
        this.strict = bl2;
    }

    @Override
    public final String getUsername() {
        return this.user;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected boolean isValidUsername(String string, ServerSession serverSession) {
        if (!super.isValidUsername(string, serverSession)) {
            return false;
        }
        String string2 = this.getUsername();
        return string.equals(string2);
    }

    @Override
    protected Collection reloadAuthorizedKeys(Path path, String string, ServerSession serverSession) {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadAuthorizedKeys({})[{}] check permissions of {}", new Object[]{string, serverSession, path});
            }
            if ((simpleImmutableEntry = KeyUtils.validateStrictKeyFilePermissions(path, new LinkOption[0])) != null) {
                this.log.warn("reloadAuthorizedKeys({})[{}] invalid file={} permissions: {}", new Object[]{string, serverSession, path, simpleImmutableEntry.getKey()});
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadAuthorizedKeys(path, string, serverSession);
    }

    protected Path validateFilePath(Path path, Collection collection, Collection collection2) {
        PosixFilePermission posixFilePermission = IoUtils.validateExcludedPermissions(collection, collection2);
        if (posixFilePermission != null) {
            String string = path.toString();
            throw new FileSystemException(string, string, "File not allowed to have " + (Object)((Object)posixFilePermission) + " permission: " + string);
        }
        return path;
    }
}

