/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;
import org.apache.sshd.server.config.keys.AuthorizedKeysAuthenticator$LazyDefaultAuthorizedKeysFileHolder;
import org.apache.sshd.server.session.ServerSession;

public class AuthorizedKeysAuthenticator
extends ModifiableFileWatcher
implements PublickeyAuthenticator {
    public static final String STD_AUTHORIZED_KEYS_FILENAME = "authorized_keys";
    private final AtomicReference delegateHolder = new AtomicReference<RejectAllPublickeyAuthenticator>(RejectAllPublickeyAuthenticator.INSTANCE);

    public AuthorizedKeysAuthenticator(Path path) {
        this(path, IoUtils.getLinkOptions(false));
    }

    public AuthorizedKeysAuthenticator(Path path, LinkOption ... linkOptionArray) {
        super(path, linkOptionArray);
    }

    @Override
    public boolean authenticate(String string, PublicKey publicKey, ServerSession serverSession) {
        boolean bl2 = this.log.isDebugEnabled();
        if (!this.isValidUsername(string, serverSession)) {
            if (bl2) {
                this.log.debug("authenticate({})[{}][{}] invalid user name - file = {}", new Object[]{string, serverSession, publicKey.getAlgorithm(), this.getPath()});
            }
            return false;
        }
        try {
            PublickeyAuthenticator publickeyAuthenticator = Objects.requireNonNull(this.resolvePublickeyAuthenticator(string, serverSession), "No delegate");
            boolean bl3 = publickeyAuthenticator.authenticate(string, publicKey, serverSession);
            if (bl2) {
                this.log.debug("authenticate({})[{}][{}] invalid user name - accepted={} from file = {}", new Object[]{string, serverSession, publicKey.getAlgorithm(), bl3, this.getPath()});
            }
            return bl3;
        }
        catch (Throwable throwable) {
            this.debug("authenticate({})[{}] failed ({}) to authenticate {} key from {}: {}", string, serverSession, throwable.getClass().getSimpleName(), publicKey.getAlgorithm(), this.getPath(), throwable.getMessage(), throwable);
            return false;
        }
    }

    protected boolean isValidUsername(String string, ServerSession serverSession) {
        return GenericUtils.isNotEmpty(string);
    }

    protected PublickeyAuthenticator resolvePublickeyAuthenticator(String string, ServerSession serverSession) {
        if (this.checkReloadRequired()) {
            this.delegateHolder.set(RejectAllPublickeyAuthenticator.INSTANCE);
            Path path = this.getPath();
            if (this.exists()) {
                Collection collection = this.reloadAuthorizedKeys(path, string, serverSession);
                if (GenericUtils.size(collection) > 0) {
                    PublickeyAuthenticator publickeyAuthenticator = this.createDelegateAuthenticator(string, serverSession, path, collection, this.getFallbackPublicKeyEntryResolver());
                    this.delegateHolder.set(publickeyAuthenticator);
                }
            } else {
                this.log.info("resolvePublickeyAuthenticator({})[{}] no authorized keys file at {}", new Object[]{string, serverSession, path});
            }
        }
        return (PublickeyAuthenticator)this.delegateHolder.get();
    }

    protected PublickeyAuthenticator createDelegateAuthenticator(String string, ServerSession serverSession, Path path, Collection collection, PublicKeyEntryResolver publicKeyEntryResolver) {
        return PublickeyAuthenticator.fromAuthorizedEntries(path, serverSession, collection, publicKeyEntryResolver);
    }

    protected PublicKeyEntryResolver getFallbackPublicKeyEntryResolver() {
        return PublicKeyEntryResolver.IGNORING;
    }

    protected Collection reloadAuthorizedKeys(Path path, String string, ServerSession serverSession) {
        List list = AuthorizedKeyEntry.readAuthorizedKeys(path, new OpenOption[0]);
        this.log.info("reloadAuthorizedKeys({})[{}] loaded {} keys from {}", new Object[]{string, serverSession, GenericUtils.size(list), path});
        this.updateReloadAttributes();
        return list;
    }

    public static Path getDefaultAuthorizedKeysFile() {
        return AuthorizedKeysAuthenticator$LazyDefaultAuthorizedKeysFileHolder.access$000();
    }

    public static List readDefaultAuthorizedKeys(OpenOption ... openOptionArray) {
        Path path = AuthorizedKeysAuthenticator.getDefaultAuthorizedKeysFile();
        if (Files.exists(path, IoUtils.EMPTY_LINK_OPTIONS)) {
            return AuthorizedKeyEntry.readAuthorizedKeys(path, new OpenOption[0]);
        }
        return Collections.emptyList();
    }
}

