/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.ConfigFileReaderSupport;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.session.SessionHeartbeatController$HeartbeatType;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.config.AllowTcpForwardingValue;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;

public final class SshServerConfigFileReader {
    public static final Property ALLOW_TCP_FORWARDING_CONFIG_PROP = Property.string("AllowTcpForwarding", "yes");
    public static final Property ALLOW_AGENT_FORWARDING_CONFIG_PROP = Property.string("AllowAgentForwarding", "yes");
    public static final Property ALLOW_X11_FORWARDING_CONFIG_PROP = Property.string("X11Forwarding", "no");
    public static final Property BANNER_CONFIG_PROP = Property.string("Banner");
    public static final Property VISUAL_HOST_KEY = Property.string("VisualHostKey", "no");
    public static final Property SERVER_ALIVE_INTERVAL_PROP = Property.duration("ServerAliveInterval");
    public static final Property SFTP_FORCED_VERSION_PROP = Property.integer("sftp-version");

    private SshServerConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static ServerFactoryManager setupServerHeartbeat(ServerFactoryManager serverFactoryManager, PropertyResolver propertyResolver) {
        if (serverFactoryManager == null || propertyResolver == null) {
            return serverFactoryManager;
        }
        Duration duration = (Duration)SERVER_ALIVE_INTERVAL_PROP.getOrNull(propertyResolver);
        if (duration == null || GenericUtils.isNegativeOrNull(duration)) {
            return serverFactoryManager;
        }
        serverFactoryManager.setSessionHeartbeat(SessionHeartbeatController$HeartbeatType.IGNORE, duration);
        return serverFactoryManager;
    }

    public static ServerFactoryManager setupServerHeartbeat(ServerFactoryManager serverFactoryManager, Map map) {
        if (serverFactoryManager == null || MapEntryUtils.isEmpty(map)) {
            return serverFactoryManager;
        }
        return SshServerConfigFileReader.setupServerHeartbeat(serverFactoryManager, PropertyResolverUtils.toPropertyResolver(map));
    }

    public static ServerFactoryManager setupSftpSubsystem(ServerFactoryManager serverFactoryManager, PropertyResolver propertyResolver) {
        if (serverFactoryManager == null || propertyResolver == null) {
            return serverFactoryManager;
        }
        Integer n2 = (Integer)SFTP_FORCED_VERSION_PROP.getOrNull(propertyResolver);
        if (n2 != null && n2 >= 0) {
            SFTP_FORCED_VERSION_PROP.set(serverFactoryManager, n2);
        }
        return serverFactoryManager;
    }

    public static SshServer configure(SshServer sshServer, PropertyResolver propertyResolver, boolean bl2, boolean bl3) {
        SshConfigFileReader.configure(sshServer, propertyResolver, bl2, bl3);
        SshConfigFileReader.configureKeyExchanges((AbstractFactoryManager)sshServer, propertyResolver, bl2, ServerBuilder.DH2KEX, bl3);
        SshServerConfigFileReader.setupServerHeartbeat((ServerFactoryManager)sshServer, propertyResolver);
        return sshServer;
    }

    public static ForwardingFilter resolveServerForwarding(PropertyResolver propertyResolver) {
        if (PropertyResolver.isEmpty(propertyResolver)) {
            return AcceptAllForwardingFilter.INSTANCE;
        }
        AgentForwardingFilter agentForwardingFilter = SshServerConfigFileReader.resolveAgentForwardingFilter(propertyResolver);
        TcpForwardingFilter tcpForwardingFilter = SshServerConfigFileReader.resolveTcpForwardingFilter(propertyResolver);
        X11ForwardingFilter x11ForwardingFilter = SshServerConfigFileReader.resolveX11ForwardingFilter(propertyResolver);
        return ForwardingFilter.asForwardingFilter(agentForwardingFilter, x11ForwardingFilter, tcpForwardingFilter);
    }

    public static AgentForwardingFilter resolveAgentForwardingFilter(PropertyResolver propertyResolver) {
        String string = (String)ALLOW_AGENT_FORWARDING_CONFIG_PROP.getRequired(propertyResolver);
        return AgentForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue(string));
    }

    public static TcpForwardingFilter resolveTcpForwardingFilter(PropertyResolver propertyResolver) {
        String string = (String)ALLOW_TCP_FORWARDING_CONFIG_PROP.getRequired(propertyResolver);
        AllowTcpForwardingValue allowTcpForwardingValue = AllowTcpForwardingValue.fromString(string);
        ValidateUtils.checkNotNull((Object)allowTcpForwardingValue, "Unknown %s value: %s", ALLOW_TCP_FORWARDING_CONFIG_PROP, string);
        return allowTcpForwardingValue;
    }

    public static X11ForwardingFilter resolveX11ForwardingFilter(PropertyResolver propertyResolver) {
        String string = (String)ALLOW_X11_FORWARDING_CONFIG_PROP.getRequired(propertyResolver);
        return X11ForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue(string));
    }

    public static Object resolveBanner(PropertyResolver propertyResolver) {
        String string = (String)BANNER_CONFIG_PROP.getOrNull(propertyResolver);
        if (GenericUtils.isEmpty(string)) {
            string = (String)VISUAL_HOST_KEY.getRequired(propertyResolver);
            string = ConfigFileReaderSupport.parseBooleanValue(string) ? "#auto-welcome-banner" : null;
        }
        if (GenericUtils.isEmpty(string)) {
            return "Welcome to SSHD\n";
        }
        if (PropertyResolverUtils.isNoneValue(string)) {
            return null;
        }
        if ("#auto-welcome-banner".equalsIgnoreCase(string)) {
            return string;
        }
        if (string != null) {
            return Paths.get(string, new String[0]);
        }
        return null;
    }
}

