/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.nio.file.FileSystem;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.AbstractCommandSupport;

public abstract class AbstractFileSystemCommand
extends AbstractCommandSupport
implements FileSystemAware {
    protected FileSystem fileSystem;

    protected AbstractFileSystemCommand(String string, CloseableExecutorService closeableExecutorService) {
        super(string, closeableExecutorService);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroy(ChannelSession channelSession) {
        try {
            super.destroy(channelSession);
            if (this.fileSystem == null) return;
        }
        catch (Throwable throwable) {
            if (this.fileSystem == null) throw throwable;
            try {
                this.fileSystem.close();
                throw throwable;
            }
            catch (IOException | UnsupportedOperationException exception) {
                if (!this.log.isDebugEnabled()) throw throwable;
                this.log.debug("destroy({}) - failed ({}) to close file system={}: {}", new Object[]{this, exception.getClass().getSimpleName(), this.fileSystem, exception.getMessage()});
                throw throwable;
            }
            finally {
                this.fileSystem = null;
            }
        }
        try {
            this.fileSystem.close();
            return;
        }
        catch (IOException | UnsupportedOperationException exception) {
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("destroy({}) - failed ({}) to close file system={}: {}", new Object[]{this, exception.getClass().getSimpleName(), this.fileSystem, exception.getMessage()});
            return;
        }
        finally {
            this.fileSystem = null;
        }
    }
}

