/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;

public abstract class AbstractDelegatingCommandFactory
extends AbstractLoggingBean
implements CommandFactory {
    private final String name;
    private CommandFactory delegate;

    protected AbstractDelegatingCommandFactory(String string) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(string, "No delegating command factory name provided");
    }

    public String toString() {
        return this.name;
    }

    public CommandFactory getDelegateCommandFactory() {
        return this.delegate;
    }

    public void setDelegateCommandFactory(CommandFactory commandFactory) {
        this.delegate = commandFactory;
    }

    @Override
    public Command createCommand(ChannelSession channelSession, String string) {
        if (this.isSupportedCommand(channelSession, string)) {
            return this.executeSupportedCommand(channelSession, string);
        }
        CommandFactory commandFactory = this.getDelegateCommandFactory();
        if (commandFactory != null) {
            return commandFactory.createCommand(channelSession, string);
        }
        return this.createUnsupportedCommand(channelSession, string);
    }

    public abstract boolean isSupportedCommand(ChannelSession var1, String var2);

    protected abstract Command executeSupportedCommand(ChannelSession var1, String var2);

    protected Command createUnsupportedCommand(ChannelSession channelSession, String string) {
        throw new IllegalArgumentException("Unknown command to execute: " + string);
    }
}

