/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.apache.sshd.server.session.ServerSessionHolder;

public abstract class AbstractCommandSupport
extends AbstractLoggingBean
implements Runnable,
SessionHolder,
ExecutorServiceCarrier,
Command,
ServerSessionAware,
ServerSessionHolder {
    protected volatile Thread cmdRunner;
    protected CloseableExecutorService executorService;
    protected boolean cbCalled;
    private final String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private Environment environment;
    private Future cmdFuture;
    private ServerSession serverSession;

    protected AbstractCommandSupport(String string, CloseableExecutorService closeableExecutorService) {
        this.command = string;
        if (closeableExecutorService == null) {
            String string2 = GenericUtils.isEmpty(string) ? this.getClass().getSimpleName() : string.replace(' ', '_').replace('/', ':');
            this.executorService = ThreadUtils.newSingleThreadExecutor(string2 + "-" + Math.abs(System.nanoTime() & 0xFFFFL));
        } else {
            this.executorService = closeableExecutorService;
        }
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public ServerSession getSession() {
        return this.getServerSession();
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public void setSession(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.executorService;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    @Override
    public void setErrorStream(OutputStream outputStream) {
        this.err = outputStream;
    }

    public ExitCallback getExitCallback() {
        return this.callback;
    }

    @Override
    public void setExitCallback(ExitCallback exitCallback) {
        this.callback = exitCallback;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected Future getStartedCommandFuture() {
        return this.cmdFuture;
    }

    @Override
    public void start(ChannelSession channelSession, Environment environment) {
        this.environment = environment;
        String string = this.getCommand();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("start({}) starting runner for command={}", (Object)channelSession, (Object)string);
            }
            CloseableExecutorService closeableExecutorService = this.getExecutorService();
            this.cmdFuture = closeableExecutorService.submit(() -> {
                this.cmdRunner = Thread.currentThread();
                this.run();
            });
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("start(" + channelSession + ") failed to start command " + string, runtimeException);
        }
    }

    @Override
    public void destroy(ChannelSession channelSession) {
        boolean bl2 = this.log.isDebugEnabled();
        if (this.cmdFuture != null && !this.cmdFuture.isDone() && this.cmdRunner != Thread.currentThread()) {
            boolean bl3 = this.cmdFuture.cancel(true);
            if (bl2) {
                this.log.debug("destroy({})[{}] - cancel pending future={}", new Object[]{channelSession, this, bl3});
            }
        }
        this.cmdFuture = null;
        CloseableExecutorService closeableExecutorService = this.getExecutorService();
        if (closeableExecutorService != null && !closeableExecutorService.isShutdown()) {
            List<Runnable> list = closeableExecutorService.shutdownNow();
            if (bl2) {
                this.log.debug("destroy({})[{}] - shutdown executor service - runners count={}", new Object[]{channelSession, this, list.size()});
            }
        }
        this.executorService = null;
    }

    protected void onExit(int n2) {
        this.onExit(n2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onExit(int n2, String string) {
        ServerSession serverSession = this.getSession();
        if (this.cbCalled) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("onExit({})[{}] ignore exitValue={}, message={} - already called", new Object[]{serverSession, this, n2, string});
            }
            return;
        }
        ExitCallback exitCallback = this.getExitCallback();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("onExit({})[{}] exiting - value={}, message={}", new Object[]{serverSession, this, n2, string});
            }
            exitCallback.onExit(n2, string);
        }
        finally {
            this.cbCalled = true;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getCommand() + "]";
    }
}

