/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.channel.AbstractChannelRequestHandler;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class PuttyRequestHandler
extends AbstractChannelRequestHandler {
    public static final String REQUEST_SUFFIX = "@putty.projects.tartarus.org";
    public static final Set PUTTY_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.ECHO, PtyMode.ICRNL, PtyMode.ONLCR));
    public static final PuttyRequestHandler INSTANCE = new PuttyRequestHandler();

    @Override
    public RequestHandler$Result process(Channel channel, String string, boolean bl2, Buffer buffer) {
        if (!PuttyRequestHandler.isPuttyRequest(string)) {
            return RequestHandler$Result.Unsupported;
        }
        String string2 = string.substring(0, string.length() - REQUEST_SUFFIX.length());
        return this.processPuttyOpcode(channel, string, string2, bl2, buffer);
    }

    protected RequestHandler$Result processPuttyOpcode(Channel channel, String string, String string2, boolean bl2, Buffer buffer) {
        if ("simple".equalsIgnoreCase(string2)) {
            return RequestHandler$Result.ReplySuccess;
        }
        if ("winadj".equalsIgnoreCase(string2)) {
            return RequestHandler$Result.ReplyFailure;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processPuttyOpcode({})[buffer size={}] [reply={}] Unknown request: {}", new Object[]{string2, buffer.available(), bl2, string});
        }
        return RequestHandler$Result.ReplyFailure;
    }

    public static boolean isPuttyRequest(String string) {
        return GenericUtils.length(string) > REQUEST_SUFFIX.length() && string.endsWith(REQUEST_SUFFIX);
    }

    public static boolean isPuttyClient(Session session) {
        return PuttyRequestHandler.isPuttyClient(session == null ? null : session.getClientVersion());
    }

    public static boolean isPuttyClient(String string) {
        return GenericUtils.length(string) > "SSH-2.0-".length() && string.startsWith("SSH-2.0-") && string.toLowerCase().contains("putty");
    }

    public static Map resolveShellTtyOptions(Map map) {
        Map map2 = PtyMode.createEnabledOptions(PUTTY_OPTIONS);
        if (MapEntryUtils.size(map) > 0) {
            map2.putAll(map);
        }
        return map2;
    }
}

