/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.util.io.output.LoggingFilterOutputStream;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;

public class PipeDataReceiver
extends AbstractLoggingBean
implements ChannelDataReceiver {
    private InputStream in;
    private OutputStream out;

    public PipeDataReceiver(PropertyResolver propertyResolver, LocalWindow localWindow) {
        ChannelPipedInputStream channelPipedInputStream = new ChannelPipedInputStream(propertyResolver, localWindow);
        this.in = channelPipedInputStream;
        this.out = new ChannelPipedOutputStream(channelPipedInputStream);
        if (this.log.isTraceEnabled()) {
            this.out = new LoggingFilterOutputStream(this.out, "IN(" + propertyResolver + "): ", this.log, propertyResolver);
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public int data(ChannelSession channelSession, byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
        return 0;
    }
}

