/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.output.LoggingFilterOutputStream;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.StandardEnvironment;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.AsyncDataReceiver;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession$CommandCloseable;
import org.apache.sshd.server.channel.ChannelSessionAware;
import org.apache.sshd.server.channel.PipeDataReceiver;
import org.apache.sshd.server.channel.PuttyRequestHandler;
import org.apache.sshd.server.command.AsyncCommandInputStreamAware;
import org.apache.sshd.server.command.AsyncCommandStreamsAware;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ChannelSession
extends AbstractServerChannel {
    public static final List DEFAULT_HANDLERS = Collections.singletonList(PuttyRequestHandler.INSTANCE);
    protected String type;
    protected ChannelAsyncOutputStream asyncOut;
    protected ChannelAsyncOutputStream asyncErr;
    protected OutputStream out;
    protected OutputStream err;
    protected Command commandInstance;
    protected ChannelDataReceiver receiver;
    protected ChannelDataReceiver extendedDataWriter;
    protected Buffer receiverBuffer;
    protected Buffer extendedDataBuffer;
    protected final AtomicBoolean commandStarted = new AtomicBoolean(false);
    protected final StandardEnvironment env = new StandardEnvironment();
    protected final CloseFuture commandExitFuture = new DefaultCloseFuture(this.getClass().getSimpleName(), this.futureLock);

    public ChannelSession() {
        this(DEFAULT_HANDLERS);
    }

    public ChannelSession(Collection collection) {
        super("", collection, null);
    }

    @Override
    public ServerSession getSession() {
        return (ServerSession)super.getSession();
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) {
        super.handleWindowAdjust(buffer);
        if (this.asyncOut != null) {
            this.asyncOut.onWindowExpanded();
        }
    }

    @Override
    protected boolean mayWrite() {
        if (this.asyncOut == null) {
            return super.mayWrite();
        }
        return !this.isClosed();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(new ChannelSession$CommandCloseable(this)).parallel(this.asyncOut, this.asyncErr).close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        IOException iOException;
        if (this.commandInstance != null) {
            try {
                this.commandInstance.destroy(this);
            }
            catch (Throwable throwable) {
                this.warn("doCloseImmediately({}) failed ({}) to destroy command: {}", this, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            }
            finally {
                this.commandInstance = null;
            }
        }
        if ((iOException = IoUtils.closeQuietly(this.getRemoteWindow(), this.out, this.err, this.receiver, this.extendedDataWriter)) != null) {
            this.debug("doCloseImmediately({}) failed ({}) to close resources: {}", this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
        }
    }

    @Override
    public void handleEof() {
        super.handleEof();
        IOException iOException = IoUtils.closeQuietly(this.receiver, this.extendedDataWriter);
        if (iOException != null) {
            this.debug("handleEof({}) failed ({}) to close receiver(s): {}", this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
        }
    }

    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        if (this.isClosing()) {
            return;
        }
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        int n3 = (int)l2;
        if (this.receiver != null) {
            int n4 = this.receiver.data(this, byArray, n2, n3);
            if (n4 > 0) {
                LocalWindow localWindow = this.getLocalWindow();
                localWindow.release(n4);
            }
        } else {
            ValidateUtils.checkTrue(l2 <= 0x7FFFFFBFL, "Temporary data length exceeds int boundaries: %d", l2);
            if (this.receiverBuffer == null) {
                this.receiverBuffer = new ByteArrayBuffer(n3 + 64, false);
            }
            this.receiverBuffer.putRawBytes(byArray, n2, n3);
        }
    }

    @Override
    protected void doWriteExtendedData(byte[] byArray, int n2, long l2) {
        int n3;
        int n4;
        ValidateUtils.checkTrue(l2 <= 0x7FFFFFBFL, "Extended data length exceeds int boundaries: %d", l2);
        if (this.extendedDataWriter != null) {
            this.extendedDataWriter.data(this, byArray, n2, (int)l2);
            return;
        }
        int n5 = this.extendedDataBuffer == null ? 0 : this.extendedDataBuffer.available();
        int n6 = n5 + (n4 = (int)l2);
        if (n6 > (n3 = ((Integer)CoreModuleProperties.MAX_EXTDATA_BUFSIZE.getRequired(this)).intValue())) {
            if (n5 <= 0 && n3 <= 0) {
                throw new UnsupportedOperationException("Session channel does not support extended data");
            }
            throw new IndexOutOfBoundsException("Extended data buffer size (" + n3 + ") exceeded");
        }
        if (this.extendedDataBuffer == null) {
            this.extendedDataBuffer = new ByteArrayBuffer(n6 + 64, false);
        }
        this.extendedDataBuffer.putRawBytes(byArray, n2, n4);
    }

    @Override
    protected RequestHandler$Result handleInternalRequest(String string, boolean bl2, Buffer buffer) {
        switch (string) {
            case "env": {
                return this.handleEnv(buffer, bl2);
            }
            case "pty-req": {
                return this.handlePtyReq(buffer, bl2);
            }
            case "window-change": {
                return this.handleWindowChange(buffer, bl2);
            }
            case "signal": {
                return this.handleSignal(buffer, bl2);
            }
            case "break": {
                return this.handleBreak(buffer, bl2);
            }
            case "shell": {
                if (this.type == null) {
                    RequestHandler$Result requestHandler$Result = this.handleShell(string, buffer, bl2);
                    if (RequestHandler$Result.ReplySuccess.equals((Object)requestHandler$Result) || RequestHandler$Result.Replied.equals((Object)requestHandler$Result)) {
                        this.type = string;
                    }
                    return requestHandler$Result;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, bl2, string, this.type});
                }
                return RequestHandler$Result.ReplyFailure;
            }
            case "exec": {
                if (this.type == null) {
                    RequestHandler$Result requestHandler$Result = this.handleExec(string, buffer, bl2);
                    if (RequestHandler$Result.ReplySuccess.equals((Object)requestHandler$Result) || RequestHandler$Result.Replied.equals((Object)requestHandler$Result)) {
                        this.type = string;
                    }
                    return requestHandler$Result;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, bl2, string, this.type});
                }
                return RequestHandler$Result.ReplyFailure;
            }
            case "subsystem": {
                if (this.type == null) {
                    RequestHandler$Result requestHandler$Result = this.handleSubsystem(string, buffer, bl2);
                    if (RequestHandler$Result.ReplySuccess.equals((Object)requestHandler$Result) || RequestHandler$Result.Replied.equals((Object)requestHandler$Result)) {
                        this.type = string;
                    }
                    return requestHandler$Result;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleInternalRequest({})[want-reply={}] type already set for request={}: {}", new Object[]{this, bl2, string, this.type});
                }
                return RequestHandler$Result.ReplyFailure;
            }
            case "auth-agent-req": 
            case "auth-agent-req@openssh.com": {
                return this.handleAgentForwarding(string, buffer, bl2);
            }
            case "x11-req": {
                return this.handleX11Forwarding(string, buffer, bl2);
            }
        }
        return super.handleInternalRequest(string, bl2, buffer);
    }

    @Override
    protected IoWriteFuture sendResponse(Buffer buffer, String string, RequestHandler$Result requestHandler$Result, boolean bl2) {
        IoWriteFuture ioWriteFuture = super.sendResponse(buffer, string, requestHandler$Result, bl2);
        if (!RequestHandler$Result.ReplySuccess.equals((Object)requestHandler$Result)) {
            return ioWriteFuture;
        }
        if (this.commandInstance == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} no pending command", (Object)this, (Object)string);
            }
            return ioWriteFuture;
        }
        if (!Objects.equals(this.type, string)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} mismatched channel type: {}", new Object[]{this, string, this.type});
            }
            return ioWriteFuture;
        }
        if (this.commandStarted.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendResponse({}) request={} pending command already started", (Object)this, (Object)string);
            }
            return ioWriteFuture;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendResponse({}) request={} activate command", (Object)this, (Object)string);
        }
        this.commandInstance.start(this, this.getEnvironment());
        return ioWriteFuture;
    }

    protected RequestHandler$Result handleEnv(Buffer buffer, boolean bl2) {
        String string = buffer.getString();
        String string2 = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleEnv({}): {} = {}", new Object[]{this, string, string2});
        }
        return this.handleEnvParsed(string, string2);
    }

    protected RequestHandler$Result handleEnvParsed(String string, String string2) {
        this.addEnvVariable(string, string2);
        return RequestHandler$Result.ReplySuccess;
    }

    protected RequestHandler$Result handlePtyReq(Buffer buffer, boolean bl2) {
        String string = buffer.getString();
        int n2 = buffer.getInt();
        int n3 = buffer.getInt();
        int n4 = buffer.getInt();
        int n5 = buffer.getInt();
        byte[] byArray = buffer.getBytes();
        HashMap<PtyMode, Integer> hashMap = new HashMap<PtyMode, Integer>();
        int n6 = 0;
        while (n6 < byArray.length && byArray[n6] != 0) {
            int n7;
            if ((n7 = byArray[n6++] & 0xFF) >= 160 && n7 <= 255) {
                this.log.warn("handlePtyReq({}) unknown reserved pty opcode value: {}", (Object)this, (Object)n7);
                break;
            }
            int n8 = byArray[n6++] << 24 & 0xFF000000 | byArray[n6++] << 16 & 0xFF0000 | byArray[n6++] << 8 & 0xFF00 | byArray[n6++] & 0xFF;
            PtyMode ptyMode = PtyMode.fromInt(n7);
            if (ptyMode == null) {
                this.log.warn("handlePtyReq({}) unsupported pty opcode value: {}={}", new Object[]{this, n7, n8});
                continue;
            }
            hashMap.put(ptyMode, n8);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("handlePtyReq({}): term={}, size=({} - {}), pixels=({}, {}), modes=[{}]", new Object[]{this, string, n2, n3, n4, n5, hashMap});
        }
        return this.handlePtyReqParsed(string, n2, n3, n4, n5, hashMap);
    }

    protected RequestHandler$Result handlePtyReqParsed(String string, int n2, int n3, int n4, int n5, Map map) {
        StandardEnvironment standardEnvironment = this.getEnvironment();
        standardEnvironment.getPtyModes().putAll(map);
        this.addEnvVariable("TERM", string);
        this.addEnvVariable("COLUMNS", Integer.toString(n2));
        this.addEnvVariable("LINES", Integer.toString(n3));
        return RequestHandler$Result.ReplySuccess;
    }

    protected RequestHandler$Result handleWindowChange(Buffer buffer, boolean bl2) {
        int n2 = buffer.getInt();
        int n3 = buffer.getInt();
        int n4 = buffer.getInt();
        int n5 = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWindowChange({}): ({} - {}), ({}, {})", new Object[]{this, n2, n3, n4, n5});
        }
        return this.handleWindowChangeParsed(n2, n3, n4, n5);
    }

    protected RequestHandler$Result handleWindowChangeParsed(int n2, int n3, int n4, int n5) {
        StandardEnvironment standardEnvironment = this.getEnvironment();
        standardEnvironment.set("COLUMNS", Integer.toString(n2));
        standardEnvironment.set("LINES", Integer.toString(n3));
        standardEnvironment.signal(this, Signal.WINCH);
        return RequestHandler$Result.ReplySuccess;
    }

    protected RequestHandler$Result handleSignal(Buffer buffer, boolean bl2) {
        String string = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSignal({}): {}", (Object)this, (Object)string);
        }
        return this.handleSignalParsed(string);
    }

    protected RequestHandler$Result handleSignalParsed(String string) {
        Signal signal = Signal.get(string);
        if (signal != null) {
            StandardEnvironment standardEnvironment = this.getEnvironment();
            standardEnvironment.signal(this, signal);
        } else {
            this.log.warn("handleSignal({}) unknown signal received: {}", (Object)this, (Object)string);
        }
        return RequestHandler$Result.ReplySuccess;
    }

    protected RequestHandler$Result handleBreak(Buffer buffer, boolean bl2) {
        long l2 = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleBreak({}) length={}", (Object)this, (Object)l2);
        }
        return this.handleBreakParsed(l2);
    }

    protected RequestHandler$Result handleBreakParsed(long l2) {
        StandardEnvironment standardEnvironment = this.getEnvironment();
        standardEnvironment.signal(this, Signal.INT);
        return RequestHandler$Result.ReplySuccess;
    }

    protected RequestHandler$Result handleShell(String string, Buffer buffer, boolean bl2) {
        if (this.isClosing()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - closing", (Object)this);
            }
            return RequestHandler$Result.ReplyFailure;
        }
        return this.handleShellParsed(string);
    }

    protected RequestHandler$Result handleShellParsed(String string) {
        ServerSession serverSession = Objects.requireNonNull(this.getServerSession(), "No server session");
        ServerFactoryManager serverFactoryManager = Objects.requireNonNull(serverSession.getFactoryManager(), "No server factory manager");
        ShellFactory shellFactory = serverFactoryManager.getShellFactory();
        if (shellFactory == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - no shell factory", (Object)this);
            }
            return RequestHandler$Result.ReplyFailure;
        }
        try {
            this.commandInstance = shellFactory.createShell(this);
        }
        catch (IOException | Error | RuntimeException throwable) {
            this.warn("handleShell({}) Failed ({}) to create shell: {}", this, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
            return RequestHandler$Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleShell({}) - no shell command", (Object)this);
            }
            return RequestHandler$Result.ReplyFailure;
        }
        return this.prepareChannelCommand(string, this.commandInstance);
    }

    protected RequestHandler$Result handleExec(String string, Buffer buffer, boolean bl2) {
        if (this.isClosing()) {
            return RequestHandler$Result.ReplyFailure;
        }
        String string2 = buffer.getString();
        return this.handleExecParsed(string, string2);
    }

    protected RequestHandler$Result handleExecParsed(String string, String string2) {
        ServerSession serverSession = Objects.requireNonNull(this.getServerSession(), "No server session");
        ServerFactoryManager serverFactoryManager = Objects.requireNonNull(serverSession.getFactoryManager(), "No server factory manager");
        CommandFactory commandFactory = serverFactoryManager.getCommandFactory();
        if (commandFactory == null) {
            this.log.warn("handleExec({}) No command factory for command: {}", (Object)this, (Object)string2);
            return RequestHandler$Result.ReplyFailure;
        }
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("handleExec({}) Executing command: {}", (Object)this, (Object)string2);
        }
        try {
            this.commandInstance = commandFactory.createCommand(this, string2);
        }
        catch (IOException | Error | RuntimeException throwable) {
            this.warn("handleExec({}) Failed ({}) to create command for {}: {}", this, throwable.getClass().getSimpleName(), string2, throwable.getMessage(), throwable);
            return RequestHandler$Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            this.log.warn("handleExec({}) Unsupported command: {}", (Object)this, (Object)string2);
            return RequestHandler$Result.ReplyFailure;
        }
        return this.prepareChannelCommand(string, this.commandInstance);
    }

    protected RequestHandler$Result handleSubsystem(String string, Buffer buffer, boolean bl2) {
        String string2 = buffer.getString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSubsystem({})[want-reply={}] subsystem={}", new Object[]{this, bl2, string2});
        }
        return this.handleSubsystemParsed(string, string2);
    }

    protected RequestHandler$Result handleSubsystemParsed(String string, String string2) {
        ServerFactoryManager serverFactoryManager = Objects.requireNonNull(this.getServerSession(), "No server session").getFactoryManager();
        List list = Objects.requireNonNull(serverFactoryManager, "No server factory manager").getSubsystemFactories();
        if (GenericUtils.isEmpty(list)) {
            this.log.warn("handleSubsystem({}) No factories for subsystem: {}", (Object)this, (Object)string2);
            return RequestHandler$Result.ReplyFailure;
        }
        try {
            this.commandInstance = SubsystemFactory.createSubsystem(this, list, string2);
        }
        catch (IOException | Error | RuntimeException throwable) {
            this.warn("handleSubsystem({}) Failed ({}) to create command for subsystem={}: {}", this, throwable.getClass().getSimpleName(), string2, throwable.getMessage(), throwable);
            return RequestHandler$Result.ReplyFailure;
        }
        if (this.commandInstance == null) {
            this.log.warn("handleSubsystem({}) Unsupported subsystem: {}", (Object)this, (Object)string2);
            return RequestHandler$Result.ReplyFailure;
        }
        return this.prepareChannelCommand(string, this.commandInstance);
    }

    protected RequestHandler$Result prepareChannelCommand(String string, Command command) {
        Command command2 = this.prepareCommand(string, command);
        if (command2 == null) {
            this.log.warn("prepareChannelCommand({})[{}] no command prepared", (Object)this, (Object)string);
            return RequestHandler$Result.ReplyFailure;
        }
        boolean bl2 = this.log.isDebugEnabled();
        if (command2 != command) {
            if (bl2) {
                this.log.debug("prepareChannelCommand({})[{}] replaced original command", (Object)this, (Object)string);
            }
            this.commandInstance = command2;
        }
        if (bl2) {
            this.log.debug("prepareChannelCommand({})[{}] prepared command", (Object)this, (Object)string);
        }
        return RequestHandler$Result.ReplySuccess;
    }

    public void setDataReceiver(ChannelDataReceiver channelDataReceiver) {
        this.receiver = channelDataReceiver;
    }

    public void setExtendedDataWriter(ChannelDataReceiver channelDataReceiver) {
        this.extendedDataWriter = channelDataReceiver;
    }

    protected Command prepareCommand(String string2, Command command) {
        Object object;
        if (command == null) {
            return null;
        }
        ServerSession serverSession = this.getSession();
        this.addEnvVariable("USER", serverSession.getUsername());
        if (command instanceof ServerSessionAware) {
            ((ServerSessionAware)((Object)command)).setSession(serverSession);
        }
        if (command instanceof ChannelSessionAware) {
            ((ChannelSessionAware)((Object)command)).setChannelSession(this);
        }
        if (command instanceof FileSystemAware) {
            object = serverSession.getFactoryManager();
            FileSystemFactory fileSystemFactory = object.getFileSystemFactory();
            ((FileSystemAware)((Object)command)).setFileSystemFactory(fileSystemFactory, serverSession);
        }
        if (command instanceof AsyncCommandStreamsAware) {
            this.asyncOut = new ChannelAsyncOutputStream(this, 94);
            this.asyncErr = new ChannelAsyncOutputStream(this, 95);
            ((AsyncCommandStreamsAware)((Object)command)).setIoOutputStream(this.asyncOut);
            ((AsyncCommandStreamsAware)((Object)command)).setIoErrorStream(this.asyncErr);
        } else {
            object = this.getRemoteWindow();
            this.out = new ChannelOutputStream(this, (RemoteWindow)object, this.log, 94, false);
            this.err = new ChannelOutputStream(this, (RemoteWindow)object, this.log, 95, false);
            if (this.log.isTraceEnabled()) {
                this.out = new LoggingFilterOutputStream(this.out, "OUT(" + this + ")", this.log, this);
                this.err = new LoggingFilterOutputStream(this.err, "ERR(" + this + ")", this.log, this);
            }
            command.setOutputStream(this.out);
            command.setErrorStream(this.err);
        }
        if (this.receiver == null) {
            if (command instanceof AsyncCommandInputStreamAware) {
                object = new AsyncDataReceiver(this);
                this.setDataReceiver((ChannelDataReceiver)object);
                ((AsyncCommandInputStreamAware)((Object)command)).setIoInputStream(((AsyncDataReceiver)object).getIn());
            } else {
                object = new PipeDataReceiver(this, this.getLocalWindow());
                this.setDataReceiver((ChannelDataReceiver)object);
                command.setInputStream(((PipeDataReceiver)object).getIn());
            }
        }
        if (this.receiverBuffer != null) {
            object = this.receiverBuffer;
            this.receiverBuffer = null;
            this.doWriteData(((Buffer)object).array(), ((Buffer)object).rpos(), object.available());
        }
        if (this.extendedDataBuffer != null) {
            if (this.extendedDataWriter == null) {
                throw new UnsupportedOperationException("No extended data writer available though " + this.extendedDataBuffer.available() + " bytes accumulated");
            }
            object = this.extendedDataBuffer;
            this.extendedDataBuffer = null;
            this.doWriteExtendedData(((Buffer)object).array(), ((Buffer)object).rpos(), object.available());
        }
        command.setExitCallback((n2, string, bl2) -> {
            try {
                this.closeShell(n2, bl2);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("onExit({}) code={} message='{}' shell closed", new Object[]{this, n2, string});
                }
            }
            catch (IOException iOException) {
                this.log.warn("onExit({}) code={} message='{}' {} closing shell: {}", new Object[]{this, n2, string, iOException.getClass().getSimpleName(), iOException.getMessage()});
            }
        });
        return command;
    }

    protected int getPtyModeValue(PtyMode ptyMode) {
        Number number = (Number)this.getEnvironment().getPtyModes().get((Object)ptyMode);
        return number != null ? number.intValue() : 0;
    }

    protected RequestHandler$Result handleAgentForwarding(String string, Buffer buffer, boolean bl2) {
        return this.handleAgentForwardingParsed(string);
    }

    protected RequestHandler$Result handleAgentForwardingParsed(String string) {
        ServerSession serverSession = this.getServerSession();
        PropertyResolverUtils.updateProperty((PropertyResolver)serverSession, "agent-fw-auth-type", (Object)string);
        FactoryManager factoryManager = Objects.requireNonNull(serverSession.getFactoryManager(), "No session factory manager");
        AgentForwardingFilter agentForwardingFilter = factoryManager.getAgentForwardingFilter();
        SshAgentFactory sshAgentFactory = factoryManager.getAgentFactory();
        boolean bl2 = this.log.isDebugEnabled();
        try {
            if (sshAgentFactory == null || agentForwardingFilter == null || !agentForwardingFilter.canForwardAgent(serverSession, string)) {
                if (bl2) {
                    this.log.debug("handleAgentForwarding({})[haveFactory={},haveFilter={}] filtered out request={}", new Object[]{this, sshAgentFactory != null, agentForwardingFilter != null, string});
                }
                return RequestHandler$Result.ReplyFailure;
            }
        }
        catch (Error error) {
            this.warn("handleAgentForwarding({}) failed ({}) to consult forwarding filter for '{}': {}", this, error.getClass().getSimpleName(), string, error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        AgentForwardSupport agentForwardSupport = this.service.getAgentForwardSupport();
        if (agentForwardSupport == null) {
            if (bl2) {
                this.log.debug("handleAgentForwarding({}) no agent forward support", (Object)this);
            }
            return RequestHandler$Result.ReplyFailure;
        }
        String string2 = agentForwardSupport.initialize();
        this.addEnvVariable("SSH_AUTH_SOCK", string2);
        return RequestHandler$Result.ReplySuccess;
    }

    protected RequestHandler$Result handleX11Forwarding(String string, Buffer buffer, boolean bl2) {
        ServerSession serverSession = this.getServerSession();
        boolean bl3 = buffer.getBoolean();
        String string2 = buffer.getString();
        String string3 = buffer.getString();
        int n2 = buffer.getInt();
        return this.handleX11ForwardingParsed(string, serverSession, bl3, string2, string3, n2);
    }

    protected RequestHandler$Result handleX11ForwardingParsed(String string, ServerSession serverSession, boolean bl2, String string2, String string3, int n2) {
        FactoryManager factoryManager = Objects.requireNonNull(serverSession.getFactoryManager(), "No factory manager");
        X11ForwardingFilter x11ForwardingFilter = factoryManager.getX11ForwardingFilter();
        boolean bl3 = this.log.isDebugEnabled();
        try {
            if (x11ForwardingFilter == null || !x11ForwardingFilter.canForwardX11(serverSession, string)) {
                if (bl3) {
                    this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={}, filter={}: filtered request={}", new Object[]{this, bl2, string2, string3, n2, x11ForwardingFilter, string});
                }
                return RequestHandler$Result.ReplyFailure;
            }
        }
        catch (Error error) {
            this.warn("handleX11Forwarding({}) failed ({}) to consult forwarding filter for '{}': {}", this, error.getClass().getSimpleName(), string, error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        X11ForwardSupport x11ForwardSupport = this.service.getX11ForwardSupport();
        if (x11ForwardSupport == null) {
            if (bl3) {
                this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={} - no forwarder'", new Object[]{this, bl2, string2, string3, n2});
            }
            return RequestHandler$Result.ReplyFailure;
        }
        String string4 = x11ForwardSupport.createDisplay(bl2, string2, string3, n2);
        if (bl3) {
            this.log.debug("handleX11Forwarding({}) single={}, protocol={}, cookie={}, screen={} - display='{}'", new Object[]{this, bl2, string2, string3, n2, string4});
        }
        if (GenericUtils.isEmpty(string4)) {
            return RequestHandler$Result.ReplyFailure;
        }
        this.addEnvVariable("DISPLAY", string4);
        return RequestHandler$Result.ReplySuccess;
    }

    protected void addEnvVariable(String string, String string2) {
        StandardEnvironment standardEnvironment = this.getEnvironment();
        standardEnvironment.set(string, string2);
    }

    public StandardEnvironment getEnvironment() {
        return this.env;
    }

    protected void closeShell(int n2, boolean bl2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closeShell({}) exit code={}, immediate={}", new Object[]{this, n2, bl2});
        }
        if (!this.isClosing()) {
            if (this.out != null) {
                this.out.close();
            }
            this.sendEof();
            this.sendExitStatus(n2);
            this.commandExitFuture.setClosed();
            this.close(bl2);
        } else {
            this.commandExitFuture.setClosed();
        }
    }
}

