/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.channel.ChannelSession$CommandCloseable$1;
import org.apache.sshd.server.session.ServerSession;

public class ChannelSession$CommandCloseable
extends IoBaseCloseable {
    final /* synthetic */ ChannelSession this$0;

    public ChannelSession$CommandCloseable(ChannelSession channelSession) {
        this.this$0 = channelSession;
    }

    @Override
    public boolean isClosed() {
        return this.this$0.commandExitFuture.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.isClosed();
    }

    @Override
    public void addCloseFutureListener(SshFutureListener sshFutureListener) {
        this.this$0.commandExitFuture.addListener(sshFutureListener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener sshFutureListener) {
        this.this$0.commandExitFuture.removeListener(sshFutureListener);
    }

    @Override
    public CloseFuture close(boolean bl2) {
        if (bl2 || this.this$0.commandInstance == null) {
            this.this$0.commandExitFuture.setClosed();
        } else if (!this.this$0.commandExitFuture.isClosed()) {
            IOException iOException = IoUtils.closeQuietly(this.this$0.receiver, this.this$0.extendedDataWriter);
            boolean bl3 = this.log.isDebugEnabled();
            if (iOException != null && bl3) {
                this.log.debug("close({})[immediately={}] failed ({}) to close receiver(s): {}", new Object[]{this, bl2, iOException.getClass().getSimpleName(), iOException.getMessage()});
            }
            ChannelSession$CommandCloseable$1 channelSession$CommandCloseable$1 = new ChannelSession$CommandCloseable$1(this);
            ChannelSession channelSession = this.this$0;
            Duration duration = (Duration)CoreModuleProperties.COMMAND_EXIT_TIMEOUT.getRequired(channelSession);
            if (bl3) {
                this.log.debug("Wait {} ms for shell to exit cleanly on {}", (Object)duration, (Object)channelSession);
            }
            ServerSession serverSession = channelSession.getSession();
            FactoryManager factoryManager = Objects.requireNonNull(serverSession.getFactoryManager(), "No factory manager");
            ScheduledExecutorService scheduledExecutorService = Objects.requireNonNull(factoryManager.getScheduledExecutorService(), "No scheduling service");
            scheduledExecutorService.schedule(channelSession$CommandCloseable$1, duration.toMillis(), TimeUnit.MILLISECONDS);
            this.this$0.commandExitFuture.addListener(closeFuture -> channelSession$CommandCloseable$1.cancel());
        }
        return this.this$0.commandExitFuture;
    }
}

