/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.channel.ServerChannel;

public abstract class AbstractServerChannel
extends AbstractChannel
implements ServerChannel {
    protected final AtomicBoolean exitStatusSent = new AtomicBoolean(false);

    protected AbstractServerChannel(CloseableExecutorService closeableExecutorService) {
        super("", false, Collections.emptyList(), closeableExecutorService);
    }

    protected AbstractServerChannel(String string, Collection collection, CloseableExecutorService closeableExecutorService) {
        super(string, false, collection, closeableExecutorService);
    }

    @Override
    public OpenFuture open(long l2, long l3, long l4, Buffer buffer) {
        this.setRecipient(l2);
        Session session = this.getSession();
        FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        RemoteWindow remoteWindow = this.getRemoteWindow();
        remoteWindow.init(l3, l4, factoryManager);
        this.configureWindow();
        return this.doInit(buffer);
    }

    @Override
    public void handleOpenSuccess(long l2, long l3, long l4, Buffer buffer) {
        throw new UnsupportedOperationException("handleOpenSuccess(" + l2 + "," + l3 + "," + l4 + ") N/A");
    }

    @Override
    public void handleOpenFailure(Buffer buffer) {
        throw new UnsupportedOperationException("handleOpenFailure() N/A");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture defaultOpenFuture = new DefaultOpenFuture(this, this);
        String string = "doInit";
        try {
            this.signalChannelOpenSuccess();
            defaultOpenFuture.setOpened();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            string = throwable2.getClass().getSimpleName();
            this.signalChannelOpenFailure(throwable2);
            defaultOpenFuture.setException(throwable2);
        }
        finally {
            this.notifyStateChanged(string);
        }
        return defaultOpenFuture;
    }

    protected void sendExitStatus(int n2) {
        if (this.exitStatusSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendExitStatus({}) exit-status={} - already sent", (Object)this, (Object)n2);
            }
            this.notifyStateChanged("exit-status");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendExitStatus({}) SSH_MSG_CHANNEL_REQUEST exit-status={}", (Object)this, (Object)n2);
        }
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)98, 64);
        buffer.putUInt(this.getRecipient());
        buffer.putString("exit-status");
        buffer.putBoolean(false);
        buffer.putInt(n2);
        this.writePacket(buffer);
        this.notifyStateChanged("exit-status");
    }
}

