/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPublicKey
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "publickey";
    private List factories;

    public UserAuthPublicKey() {
        this((List)null);
    }

    public UserAuthPublicKey(List list) {
        super(NAME);
        this.factories = list;
    }

    @Override
    public List getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List list) {
        this.factories = list;
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean bl2) {
        boolean bl3;
        Object object;
        ValidateUtils.checkTrue(bl2, "Instance not initialized");
        ServerSession serverSession = this.getServerSession();
        String string = this.getUsername();
        boolean bl4 = buffer.getBoolean();
        String string2 = buffer.getString();
        int n2 = buffer.wpos();
        int n3 = buffer.rpos();
        int n4 = buffer.getInt();
        int n5 = buffer.available();
        if (n4 < 0 || n4 > n5) {
            this.log.error("doAuth({}@{}) illogical algorithm={} signature length ({}) when remaining={}", new Object[]{string, serverSession, string2, n4, n5});
            throw new IndexOutOfBoundsException("Illogical signature length (" + n4 + ") for algorithm=" + string2);
        }
        buffer.wpos(buffer.rpos() + n4);
        PublicKey publicKey = buffer.getRawPublicKey();
        if (publicKey instanceof OpenSshCertificate) {
            object = (OpenSshCertificate)publicKey;
            try {
                if (!OpenSshCertificate$Type.USER.equals((Object)object.getType())) {
                    throw new CertificateException("not a user certificate");
                }
                if (!OpenSshCertificate.isValidNow((OpenSshCertificate)object)) {
                    throw new CertificateException("expired");
                }
                Collection collection = object.getPrincipals();
                if (!GenericUtils.isEmpty(collection) && !collection.contains(string)) {
                    throw new CertificateException("not valid for the given username");
                }
            }
            catch (CertificateException certificateException) {
                this.warn("doAuth({}@{}): public key certificate (id={}) is not valid: {}", string, serverSession, object.getId(), certificateException.getMessage(), certificateException);
                throw certificateException;
            }
        }
        object = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, serverSession), "No signature factories for session=%s", serverSession);
        boolean bl5 = this.log.isDebugEnabled();
        if (bl5) {
            this.log.debug("doAuth({}@{}) verify key type={}, factories={}, fingerprint={}", new Object[]{string, serverSession, string2, NamedResource.getNames((Collection)object), KeyUtils.getFingerPrint(publicKey)});
        }
        Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create((Collection)object, string2)), "No verifier located for algorithm=%s", (Object)string2);
        signature.initVerifier(serverSession, publicKey);
        buffer.wpos(n2);
        byte[] byArray = bl4 ? buffer.getBytes() : null;
        PublickeyAuthenticator publickeyAuthenticator = serverSession.getPublickeyAuthenticator();
        if (publickeyAuthenticator == null) {
            if (bl5) {
                this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - no authenticator", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey)});
            }
            return Boolean.FALSE;
        }
        try {
            bl3 = publickeyAuthenticator.authenticate(string, publicKey, serverSession);
        }
        catch (Error error) {
            this.warn("doAuth({}@{}) failed ({}) to consult delegate for {} key={}: {}", string, serverSession, error.getClass().getSimpleName(), string2, KeyUtils.getFingerPrint(publicKey), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        if (bl5) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - authentication result: {}", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey), bl3});
        }
        if (!bl3) {
            return Boolean.FALSE;
        }
        if (!bl4) {
            this.sendPublicKeyResponse(serverSession, string, string2, publicKey, buffer.array(), n3, 4 + n4, buffer);
            return null;
        }
        buffer.rpos(n3);
        buffer.wpos(n3 + 4 + n4);
        if (!this.verifySignature(serverSession, string, string2, publicKey, buffer, signature, byArray)) {
            throw new SignatureException("Key verification failed");
        }
        if (bl5) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={} - verified", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey)});
        }
        return Boolean.TRUE;
    }

    protected boolean verifySignature(ServerSession serverSession, String string, String string2, PublicKey publicKey, Buffer buffer, Signature signature, byte[] byArray) {
        byte[] byArray2 = serverSession.getSessionId();
        String string3 = this.getService();
        String string4 = this.getName();
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(byArray2.length + string.length() + string3.length() + string4.length() + string2.length() + 256 + 64, false);
        byteArrayBuffer.putBytes(byArray2);
        ((Buffer)byteArrayBuffer).putByte((byte)50);
        byteArrayBuffer.putString(string);
        byteArrayBuffer.putString(string3);
        byteArrayBuffer.putString(string4);
        byteArrayBuffer.putBoolean(true);
        byteArrayBuffer.putString(string2);
        byteArrayBuffer.putBuffer(buffer);
        if (this.log.isTraceEnabled()) {
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - verification data={}", new Object[]{string, serverSession, string3, string4, string2, KeyUtils.getFingerPrint(publicKey), byteArrayBuffer.toHex()});
            this.log.trace("verifySignature({}@{})[{}][{}] key type={}, fingerprint={} - expected signature={}", new Object[]{string, serverSession, string3, string4, string2, KeyUtils.getFingerPrint(publicKey), BufferUtils.toHex(byArray)});
        }
        signature.update(serverSession, ((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), byteArrayBuffer.available());
        return signature.verify(serverSession, byArray);
    }

    protected void sendPublicKeyResponse(ServerSession serverSession, String string, String string2, PublicKey publicKey, byte[] byArray, int n2, int n3, Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) send SSH_MSG_USERAUTH_PK_OK for key type={}, fingerprint={}", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey)});
        }
        Buffer buffer2 = serverSession.createBuffer((byte)60, GenericUtils.length(string2) + n3 + 32);
        buffer2.putString(string2);
        buffer2.putRawBytes(byArray, n2, n3);
        serverSession.writePacket(buffer2);
    }
}

