/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public abstract class StaticPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    private final boolean acceptance;

    protected StaticPublickeyAuthenticator(boolean bl2) {
        this.acceptance = bl2;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(String string, PublicKey publicKey, ServerSession serverSession) {
        boolean bl2 = this.isAccepted();
        if (bl2) {
            this.handleAcceptance(string, publicKey, serverSession);
        }
        return bl2;
    }

    protected void handleAcceptance(String string, PublicKey publicKey, ServerSession serverSession) {
        this.log.warn("authenticate({}[{}][{}][{}]: accepted without checking", new Object[]{string, serverSession, publicKey == null ? "null" : publicKey.getAlgorithm(), KeyUtils.getFingerPrint(publicKey)});
    }

    protected void handleRejection(String string, PublicKey publicKey, ServerSession serverSession) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}][{}][{}]: rejected", new Object[]{string, serverSession, publicKey == null ? "null" : publicKey.getAlgorithm(), KeyUtils.getFingerPrint(publicKey)});
        }
    }
}

