/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class KeySetPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    private final Collection keySet;
    private final Object id;

    public KeySetPublickeyAuthenticator(Object object, Collection collection) {
        this.id = object;
        this.keySet = collection == null ? Collections.emptyList() : collection;
    }

    public Object getId() {
        return this.id;
    }

    public final Collection getKeySet() {
        return this.keySet;
    }

    @Override
    public boolean authenticate(String string, PublicKey publicKey, ServerSession serverSession) {
        return this.authenticate(string, publicKey, serverSession, this.getKeySet());
    }

    public boolean authenticate(String string, PublicKey publicKey, ServerSession serverSession, Collection collection) {
        boolean bl2;
        if (GenericUtils.isEmpty(collection)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no keys", (Object)string, (Object)serverSession);
            }
            return false;
        }
        PublicKey publicKey2 = KeyUtils.findMatchingKey(publicKey, collection);
        boolean bl3 = bl2 = publicKey2 != null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({})[{}] match found={}", new Object[]{string, serverSession, bl2});
        }
        return bl2;
    }

    public String toString() {
        return Objects.toString(this.getId());
    }
}

