/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class CachingPublicKeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository$AttributeKey CACHE_ATTRIBUTE = new AttributeRepository$AttributeKey();
    protected final PublickeyAuthenticator authenticator;

    public CachingPublicKeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.authenticator = Objects.requireNonNull(publickeyAuthenticator, "No delegate authenticator");
    }

    @Override
    public boolean authenticate(String string, PublicKey publicKey, ServerSession serverSession) {
        Map map = this.resolveCachedResults(string, publicKey, serverSession);
        Boolean bl2 = (Boolean)map.get(publicKey);
        if (bl2 == null) {
            try {
                bl2 = this.authenticator.authenticate(string, publicKey, serverSession);
            }
            catch (Error error) {
                this.warn("authenticate({}@{}) failed ({}) to consult delegate for {} key={}: {}", string, serverSession, error.getClass().getSimpleName(), KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey), error.getMessage(), error);
                throw new RuntimeSshException(error);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({}@{}) cache result={} for {} key={}", new Object[]{string, serverSession, bl2, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
            }
            map.put(publicKey, bl2);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}@{}) use cached result={} for {} key={}", new Object[]{string, serverSession, bl2, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
        }
        return bl2;
    }

    protected Map resolveCachedResults(String string, PublicKey publicKey, ServerSession serverSession) {
        return (Map)serverSession.computeAttributeIfAbsent(CACHE_ATTRIBUTE, attributeRepository$AttributeKey -> new ConcurrentHashMap());
    }
}

