/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class AuthorizedKeyEntriesPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository$AttributeKey AUTHORIZED_KEY = new AttributeRepository$AttributeKey();
    private Map resolvedKeys;
    private Object id;

    public AuthorizedKeyEntriesPublickeyAuthenticator(Object object, ServerSession serverSession, Collection collection, PublicKeyEntryResolver publicKeyEntryResolver) {
        this.id = object;
        int n2 = GenericUtils.size(collection);
        if (n2 <= 0) {
            this.resolvedKeys = Collections.emptyMap();
        } else {
            this.resolvedKeys = new HashMap(n2);
            for (AuthorizedKeyEntry authorizedKeyEntry : collection) {
                Map map;
                PublicKey publicKey = authorizedKeyEntry.resolvePublicKey(serverSession, map = authorizedKeyEntry.getLoginOptions(), publicKeyEntryResolver);
                if (publicKey == null) continue;
                this.resolvedKeys.put(authorizedKeyEntry, publicKey);
            }
        }
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public boolean authenticate(String string, PublicKey publicKey, ServerSession serverSession) {
        if (MapEntryUtils.isEmpty(this.resolvedKeys)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no entries", (Object)string, (Object)serverSession);
            }
            return false;
        }
        for (Map.Entry entry : this.resolvedKeys.entrySet()) {
            if (!KeyUtils.compareKeys(publicKey, (PublicKey)entry.getValue())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] match found", (Object)string, (Object)serverSession);
            }
            if (serverSession != null) {
                serverSession.setAttribute(AUTHORIZED_KEY, (AuthorizedKeyEntry)entry.getKey());
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({})[{}] match not found", (Object)string, (Object)serverSession);
        }
        return false;
    }

    public String toString() {
        return Objects.toString(this.getId());
    }
}

