/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.password;

import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean bl2) {
        ValidateUtils.checkTrue(bl2, "Instance not initialized");
        ServerSession serverSession = this.getServerSession();
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport(serverSession)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth({}) session is not secure", (Object)serverSession);
            }
            return false;
        }
        String string = this.getUsername();
        boolean bl3 = buffer.getBoolean();
        String string2 = buffer.getString();
        if (bl3) {
            return this.handleClientPasswordChangeRequest(buffer, serverSession, string, string2, buffer.getString());
        }
        return this.checkPassword(buffer, serverSession, string, string2);
    }

    protected Boolean checkPassword(Buffer buffer, ServerSession serverSession, String string, String string2) {
        boolean bl2 = this.log.isDebugEnabled();
        PasswordAuthenticator passwordAuthenticator = serverSession.getPasswordAuthenticator();
        if (passwordAuthenticator == null) {
            if (bl2) {
                this.log.debug("checkPassword({}) no password authenticator", (Object)serverSession);
            }
            return false;
        }
        try {
            boolean bl3;
            try {
                bl3 = passwordAuthenticator.authenticate(string, string2, serverSession);
            }
            catch (Error error) {
                this.warn("checkPassword({}) failed ({}) to consult authenticator: {}", serverSession, error.getClass().getSimpleName(), error.getMessage(), error);
                throw new RuntimeSshException(error);
            }
            if (bl2) {
                this.log.debug("checkPassword({}) authentication result: {}", (Object)serverSession, (Object)bl3);
            }
            return bl3;
        }
        catch (PasswordChangeRequiredException passwordChangeRequiredException) {
            if (bl2) {
                this.log.debug("checkPassword({}) password change required: {}", (Object)serverSession, (Object)passwordChangeRequiredException.getMessage());
            }
            return this.handleServerPasswordChangeRequest(buffer, serverSession, string, string2, passwordChangeRequiredException);
        }
    }

    protected Boolean handleClientPasswordChangeRequest(Buffer buffer, ServerSession serverSession, String string, String string2, String string3) {
        boolean bl2 = this.log.isDebugEnabled();
        if (!UserAuthMethodFactory.isDataIntegrityAuthenticationTransport(serverSession)) {
            if (bl2) {
                this.log.debug("handleClientPasswordChangeRequest({}) session is not validated via MAC", (Object)serverSession);
            }
            return false;
        }
        PasswordAuthenticator passwordAuthenticator = serverSession.getPasswordAuthenticator();
        if (passwordAuthenticator == null) {
            if (bl2) {
                this.log.debug("handleClientPasswordChangeRequest({}) no password authenticator", (Object)serverSession);
            }
            return false;
        }
        return passwordAuthenticator.handleClientPasswordChangeRequest(serverSession, string, string2, string3);
    }

    protected Boolean handleServerPasswordChangeRequest(Buffer buffer, ServerSession serverSession, String string, String string2, PasswordChangeRequiredException passwordChangeRequiredException) {
        String string3 = passwordChangeRequiredException.getPrompt();
        String string4 = passwordChangeRequiredException.getLanguage();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handlePasswordChangeRequest({}) password change required - prompt={}, lang={}", new Object[]{serverSession, string3, string4});
        }
        buffer = serverSession.createBuffer((byte)60, GenericUtils.length(string3) + GenericUtils.length(string4) + 32);
        buffer.putString(string3);
        buffer.putString(string4);
        serverSession.writePacket(buffer);
        return null;
    }
}

