/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.password;

import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class StaticPasswordAuthenticator
extends AbstractLoggingBean
implements PasswordAuthenticator {
    private final boolean acceptance;

    public StaticPasswordAuthenticator(boolean bl2) {
        this.acceptance = bl2;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(String string, String string2, ServerSession serverSession) {
        boolean bl2 = this.isAccepted();
        if (bl2) {
            this.handleAcceptance(string, string2, serverSession);
        } else {
            this.handleRejection(string, string2, serverSession);
        }
        return bl2;
    }

    protected void handleAcceptance(String string, String string2, ServerSession serverSession) {
        this.log.warn("authenticate({}[{}]: accepted without checking", (Object)string, (Object)serverSession);
    }

    protected void handleRejection(String string, String string2, ServerSession serverSession) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}]: rejected", (Object)string, (Object)serverSession);
        }
    }
}

