/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    public static final String NAME = "keyboard-interactive";

    public UserAuthKeyboardInteractive() {
        super(NAME);
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean bl2) {
        ServerSession serverSession = this.getServerSession();
        String string = this.getUsername();
        KeyboardInteractiveAuthenticator keyboardInteractiveAuthenticator = serverSession.getKeyboardInteractiveAuthenticator();
        if (bl2) {
            return this.doInitialAuth(serverSession, string, keyboardInteractiveAuthenticator, buffer);
        }
        return this.doValidateAuthResponse(serverSession, string, keyboardInteractiveAuthenticator, buffer);
    }

    protected Boolean doInitialAuth(ServerSession serverSession, String string, KeyboardInteractiveAuthenticator keyboardInteractiveAuthenticator, Buffer buffer) {
        InteractiveChallenge interactiveChallenge;
        String string2 = buffer.getString();
        String string3 = buffer.getString();
        boolean bl2 = this.log.isDebugEnabled();
        if (keyboardInteractiveAuthenticator == null) {
            if (bl2) {
                this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive authenticator to generate challenge", new Object[]{string, serverSession, string3, string2});
            }
            return false;
        }
        try {
            interactiveChallenge = keyboardInteractiveAuthenticator.generateChallenge(serverSession, string, string2, string3);
        }
        catch (Error error) {
            this.warn("doAuth({}@{}) failed ({}) to generate authenticator challenge: {}", string, serverSession, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        if (interactiveChallenge == null) {
            if (bl2) {
                this.log.debug("doAuth({}@{})[methods={}, lang={}] - no interactive challenge generated", new Object[]{string, serverSession, string3, string2});
            }
            return false;
        }
        if (bl2) {
            this.log.debug("doAuth({}@{})[methods={}, lang={}] challenge name={}, instruction={}, lang={}, num. prompts={}", new Object[]{string, serverSession, string3, string2, interactiveChallenge.getInteractionName(), interactiveChallenge.getInteractionInstruction(), interactiveChallenge.getLanguageTag(), GenericUtils.size(interactiveChallenge.getPrompts())});
        }
        buffer = serverSession.createBuffer((byte)60);
        interactiveChallenge.append(buffer);
        serverSession.writePacket(buffer);
        return null;
    }

    protected Boolean doValidateAuthResponse(ServerSession serverSession, String string, KeyboardInteractiveAuthenticator keyboardInteractiveAuthenticator, Buffer buffer) {
        boolean bl2;
        int n2;
        int n3 = buffer.getUByte();
        if (n3 != 61) {
            throw new SshException("Received unexpected message: " + SshConstants.getCommandMessageName(n3));
        }
        int n4 = buffer.getInt();
        if (n4 < 0 || n4 > 32768) {
            this.log.error("doValidateAuthResponse({}@{}) illogical response count: {}", new Object[]{string, serverSession, n4});
            throw new IndexOutOfBoundsException("Illogical response count: " + n4);
        }
        ArrayList<String> arrayList = n4 <= 0 ? Collections.emptyList() : new ArrayList<String>(n4);
        for (n2 = 1; n2 <= n4; ++n2) {
            String string2 = buffer.getString();
            arrayList.add(string2);
        }
        n2 = this.log.isDebugEnabled() ? 1 : 0;
        if (keyboardInteractiveAuthenticator == null) {
            if (n2 != 0) {
                this.log.debug("doAuth({}@{}) no interactive authenticator to validate {} responses", new Object[]{string, serverSession, n4});
            }
            return false;
        }
        try {
            bl2 = keyboardInteractiveAuthenticator.authenticate(serverSession, string, arrayList);
        }
        catch (Error error) {
            this.warn("doAuth({}@{}) failed ({}) to consult authenticator: {}", string, serverSession, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        if (n2 != 0) {
            this.log.debug("doAuth({}@{}) authenticate {} responses result: {}", new Object[]{string, serverSession, n4, bl2});
        }
        return bl2;
    }
}

