/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.keyboard.PromptEntry;

public class InteractiveChallenge
implements Cloneable {
    private String interactionName;
    private String interactionInstruction;
    private String languageTag;
    private List prompts = new ArrayList();

    public String getInteractionName() {
        return this.interactionName;
    }

    public void setInteractionName(String string) {
        this.interactionName = string;
    }

    public String getInteractionInstruction() {
        return this.interactionInstruction;
    }

    public void setInteractionInstruction(String string) {
        this.interactionInstruction = string;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public void setLanguageTag(String string) {
        this.languageTag = string;
    }

    public void addPrompt(String string, boolean bl2) {
        this.addPrompt(new PromptEntry(string, bl2));
    }

    public void addPrompt(PromptEntry promptEntry) {
        this.prompts.add(Objects.requireNonNull(promptEntry, "No entry"));
    }

    public List getPrompts() {
        return this.prompts;
    }

    public void setPrompts(Collection collection) {
        this.clearPrompts();
        if (GenericUtils.size(collection) > 0) {
            this.prompts.addAll(collection);
        }
    }

    public void clearPrompts() {
        this.prompts.clear();
    }

    public Buffer append(Buffer buffer) {
        buffer.putString(this.getInteractionName());
        buffer.putString(this.getInteractionInstruction());
        buffer.putString(this.getLanguageTag());
        List list = this.getPrompts();
        int n2 = GenericUtils.size(list);
        buffer.putUInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            PromptEntry promptEntry = (PromptEntry)list.get(i2);
            promptEntry.append(buffer);
        }
        return buffer;
    }

    public InteractiveChallenge clone() {
        try {
            InteractiveChallenge interactiveChallenge = (InteractiveChallenge)this.getClass().cast(super.clone());
            interactiveChallenge.prompts = new ArrayList();
            for (PromptEntry promptEntry : this.getPrompts()) {
                interactiveChallenge.addPrompt(promptEntry.clone());
            }
            return interactiveChallenge;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new UnsupportedOperationException("Failed to clone " + this.toString() + ": " + cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.getInteractionName() + "[" + this.getInteractionInstruction() + "](" + this.getLanguageTag() + "): " + this.getPrompts();
    }
}

