/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.keyboard;

import java.util.List;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class DefaultKeyboardInteractiveAuthenticator
extends AbstractLoggingBean
implements KeyboardInteractiveAuthenticator {
    public static final DefaultKeyboardInteractiveAuthenticator INSTANCE = new DefaultKeyboardInteractiveAuthenticator();

    @Override
    public InteractiveChallenge generateChallenge(ServerSession serverSession, String string, String string2, String string3) {
        PasswordAuthenticator passwordAuthenticator = serverSession.getPasswordAuthenticator();
        if (passwordAuthenticator == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("generateChallenge({})[{}] no password authenticator", (Object)serverSession, (Object)string);
            }
            return null;
        }
        InteractiveChallenge interactiveChallenge = new InteractiveChallenge();
        interactiveChallenge.setInteractionName(this.getInteractionName(serverSession));
        interactiveChallenge.setInteractionInstruction(this.getInteractionInstruction(serverSession));
        interactiveChallenge.setLanguageTag(this.getInteractionLanguage(serverSession));
        interactiveChallenge.addPrompt(this.getInteractionPrompt(serverSession), this.isInteractionPromptEchoEnabled(serverSession));
        return interactiveChallenge;
    }

    @Override
    public boolean authenticate(ServerSession serverSession, String string, List list) {
        PasswordAuthenticator passwordAuthenticator = serverSession.getPasswordAuthenticator();
        if (passwordAuthenticator == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no password authenticator", (Object)serverSession, (Object)string);
            }
            return false;
        }
        int n2 = GenericUtils.size(list);
        if (n2 != 1) {
            throw new SshException("Mismatched number of responses");
        }
        try {
            return passwordAuthenticator.authenticate(string, (String)list.get(0), serverSession);
        }
        catch (Error error) {
            this.warn("authenticate({})[{}] failed ({}) to consult password authenticator: {}", serverSession, string, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
    }

    protected String getInteractionName(ServerSession serverSession) {
        return (String)CoreModuleProperties.KB_SERVER_INTERACTIVE_NAME.getRequired(serverSession);
    }

    protected String getInteractionInstruction(ServerSession serverSession) {
        return (String)CoreModuleProperties.KB_SERVER_INTERACTIVE_INSTRUCTION.getRequired(serverSession);
    }

    protected String getInteractionLanguage(ServerSession serverSession) {
        return (String)CoreModuleProperties.KB_SERVER_INTERACTIVE_LANG.getRequired(serverSession);
    }

    protected String getInteractionPrompt(ServerSession serverSession) {
        return (String)CoreModuleProperties.KB_SERVER_INTERACTIVE_PROMPT.getRequired(serverSession);
    }

    protected boolean isInteractionPromptEchoEnabled(ServerSession serverSession) {
        return (Boolean)CoreModuleProperties.KB_SERVER_INTERACTIVE_ECHO_PROMPT.getRequired(serverSession);
    }
}

