/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.hostbased;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthHostBased
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "hostbased";
    private List factories;

    public UserAuthHostBased() {
        this((List)null);
    }

    public UserAuthHostBased(List list) {
        super(NAME);
        this.factories = list;
    }

    @Override
    public List getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List list) {
        this.factories = list;
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean bl2) {
        boolean bl3;
        HostBasedAuthenticator hostBasedAuthenticator;
        Object object;
        Object object2;
        Object object3;
        ValidateUtils.checkTrue(bl2, "Instance not initialized");
        int n2 = buffer.available();
        String string = this.getUsername();
        ServerSession serverSession = this.getSession();
        String string2 = buffer.getString();
        int n3 = buffer.getInt();
        int n4 = buffer.rpos();
        int n5 = buffer.available();
        if (n3 < 0 || n3 > n5) {
            this.log.error("doAuth({}@{}) Illogical {} key length={} (max. available={})", new Object[]{string, serverSession, string2, n3, n5});
            throw new IndexOutOfBoundsException("Illogical " + string2 + " key length: " + n3);
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(buffer.array(), n4, n3, true);
        PublicKey publicKey = byteArrayBuffer.getRawPublicKey();
        List list = Collections.emptyList();
        n5 = byteArrayBuffer.available();
        if (n5 > 0) {
            object3 = SecurityUtils.getCertificateFactory("X.509");
            list = new ArrayList();
            object2 = new ByteArrayInputStream(((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), n5);
            try {
                object = (X509Certificate)((CertificateFactory)object3).generateCertificate((InputStream)object2);
                list.add(object);
            }
            finally {
                ((ByteArrayInputStream)object2).close();
            }
        }
        buffer.rpos(n4 + n3);
        object3 = buffer.getString();
        object2 = buffer.getString();
        object = buffer.getBytes();
        boolean bl4 = this.log.isDebugEnabled();
        if (bl4) {
            this.log.debug("doAuth({}@{}) authenticate key type={}, fingerprint={}, client={}@{}, num-certs={}", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey), object2, object3, GenericUtils.size(list)});
        }
        if ((hostBasedAuthenticator = serverSession.getHostBasedAuthenticator()) == null) {
            if (bl4) {
                this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - no authenticator", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey), object2, object3, GenericUtils.size(list)});
            }
            return Boolean.FALSE;
        }
        try {
            bl3 = hostBasedAuthenticator.authenticate(serverSession, string, publicKey, (String)object3, (String)object2, list);
        }
        catch (Error error) {
            this.warn("doAuth({}@{}) failed ({}) to consult authenticator for {} key={}: {}", string, serverSession, error.getClass().getSimpleName(), string2, KeyUtils.getFingerPrint(publicKey), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        if (bl4) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - authentication result: {}", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey), object2, object3, GenericUtils.size(list), bl3});
        }
        if (!bl3) {
            return Boolean.FALSE;
        }
        Collection collection = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(this, serverSession), "No signature factories for session=%s", serverSession);
        Signature signature = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create(collection, string2)), "No verifier located for algorithm=%s", (Object)string2);
        signature.initVerifier(serverSession, publicKey);
        byte[] byArray = serverSession.getSessionId();
        byteArrayBuffer = new ByteArrayBuffer(n2 + byArray.length + 64, false);
        byteArrayBuffer.putBytes(byArray);
        ((Buffer)byteArrayBuffer).putByte((byte)50);
        byteArrayBuffer.putString(string);
        byteArrayBuffer.putString(this.getService());
        byteArrayBuffer.putString(this.getName());
        byteArrayBuffer.putString(string2);
        byteArrayBuffer.putUInt(n3);
        ((Buffer)byteArrayBuffer).putRawBytes(buffer.array(), n4, n3);
        byteArrayBuffer.putString((String)object3);
        byteArrayBuffer.putString((String)object2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - verification data: {}", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey), object2, object3, GenericUtils.size(list), byteArrayBuffer.toHex()});
            this.log.trace("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - expected signature: {}", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey), object2, object3, GenericUtils.size(list), BufferUtils.toHex(object)});
        }
        signature.update(serverSession, ((Buffer)byteArrayBuffer).array(), ((Buffer)byteArrayBuffer).rpos(), byteArrayBuffer.available());
        if (!signature.verify(serverSession, (byte[])object)) {
            throw new SignatureException("Key verification failed");
        }
        if (bl4) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - verified signature", new Object[]{string, serverSession, string2, KeyUtils.getFingerPrint(publicKey), object2, object3, GenericUtils.size(list)});
        }
        return Boolean.TRUE;
    }
}

