/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.hostbased;

import java.security.PublicKey;
import java.util.List;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class StaticHostBasedAuthenticator
extends AbstractLoggingBean
implements HostBasedAuthenticator {
    private final boolean acceptance;

    public StaticHostBasedAuthenticator(boolean bl2) {
        this.acceptance = bl2;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(ServerSession serverSession, String string, PublicKey publicKey, String string2, String string3, List list) {
        boolean bl2 = this.isAccepted();
        if (bl2) {
            this.handleAcceptance(serverSession, string, publicKey, string2, string3, list);
        } else {
            this.handleRejection(serverSession, string, publicKey, string2, string3, list);
        }
        return bl2;
    }

    protected void handleAcceptance(ServerSession serverSession, String string, PublicKey publicKey, String string2, String string3, List list) {
        this.log.warn("authenticate({}[{}]: accepted without checking {}@{} key={} fingerprint={}", new Object[]{string, serverSession, string3, string2, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
    }

    protected void handleRejection(ServerSession serverSession, String string, PublicKey publicKey, String string2, String string3, List list) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}]: rejected {}@{} key={} fingerprint={}", new Object[]{string, serverSession, string3, string2, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
        }
    }
}

