/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.gss;

import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class UserAuthGSS
extends AbstractUserAuth {
    public static final String NAME = "gssapi-with-mic";
    public static final Oid KRB5_MECH = UserAuthGSS.createOID("1.2.840.113554.1.2.2");
    public static final Oid KRB5_NT_PRINCIPAL = UserAuthGSS.createOID("1.2.840.113554.1.2.2.1");
    private GSSContext context;
    private String identity;

    public UserAuthGSS() {
        super(NAME);
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean bl2) {
        Object object;
        ServerSession serverSession = this.getServerSession();
        GSSAuthenticator gSSAuthenticator = Objects.requireNonNull(serverSession.getGSSAuthenticator(), "No GSSAuthenticator configured");
        String string = this.getUsername();
        boolean bl3 = this.log.isDebugEnabled();
        if (bl2) {
            int n2 = buffer.getInt();
            if (n2 < 0 || n2 > 32768) {
                this.log.error("doAuth({}@{}) Illogical OID entries count: {}", new Object[]{string, serverSession, n2});
                throw new IndexOutOfBoundsException("Illogical OID entries count: " + n2);
            }
            boolean bl4 = this.log.isTraceEnabled();
            for (int i2 = 1; i2 <= n2; ++i2) {
                Oid oid = new Oid(buffer.getBytes());
                if (!oid.equals(KRB5_MECH)) {
                    if (!bl4) continue;
                    this.log.trace("doAuth({}@{}) skip OID {}/{}: {}", new Object[]{string, serverSession, i2, n2, oid});
                    continue;
                }
                if (bl3) {
                    this.log.debug("doAuth({}@{}) found Kerberos 5 after {}/{} OID(s)", new Object[]{string, serverSession, i2, n2});
                }
                if (!gSSAuthenticator.validateInitialUser(serverSession, string)) {
                    return Boolean.FALSE;
                }
                GSSManager gSSManager = gSSAuthenticator.getGSSManager();
                GSSCredential gSSCredential = gSSAuthenticator.getGSSCredential(gSSManager);
                if (gSSCredential == null) {
                    return Boolean.FALSE;
                }
                this.context = gSSManager.createContext(gSSCredential);
                byte[] byArray = oid.getDER();
                Buffer buffer2 = serverSession.createBuffer((byte)60, byArray.length + 32);
                buffer2.putBytes(byArray);
                serverSession.writePacket(buffer2);
                return null;
            }
            return Boolean.FALSE;
        }
        int n3 = buffer.getUByte();
        if (!(n3 == 61 || n3 == 66 && this.context.isEstablished())) {
            throw new SshException(2, "Packet not supported by user authentication method: " + SshConstants.getCommandMessageName(n3));
        }
        if (bl3) {
            this.log.debug("doAuth({}@{}) In krb5.next: msg = {}", new Object[]{string, serverSession, SshConstants.getCommandMessageName(n3)});
        }
        if (this.context.isEstablished()) {
            if (n3 != 66) {
                return Boolean.FALSE;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.putBytes(ValidateUtils.checkNotNullAndNotEmpty(serverSession.getSessionId(), "No current session ID"));
            ((Buffer)byteArrayBuffer).putByte((byte)50);
            byteArrayBuffer.putString(this.getUsername());
            byteArrayBuffer.putString(this.getService());
            byteArrayBuffer.putString(this.getName());
            byte[] byArray = byteArrayBuffer.getCompactData();
            byte[] byArray2 = buffer.getBytes();
            try {
                this.context.verifyMIC(byArray2, 0, byArray2.length, byArray, 0, byArray.length, new MessageProp(false));
                if (bl3) {
                    this.log.debug("doAuth({}@{}) MIC verified", (Object)this.getUsername(), (Object)serverSession);
                }
                return Boolean.TRUE;
            }
            catch (GSSException gSSException) {
                if (bl3) {
                    this.log.debug("doAuth({}@{}) GSS verification {} error: {}", new Object[]{string, serverSession, gSSException.getClass().getSimpleName(), gSSException.getMessage()});
                }
                return Boolean.FALSE;
            }
        }
        byte[] byArray = buffer.getBytes();
        byte[] byArray3 = this.context.acceptSecContext(byArray, 0, byArray.length);
        boolean bl5 = this.context.isEstablished();
        if (bl5 && this.identity == null) {
            object = this.context.getSrcName();
            this.identity = object.toString();
            if (bl3) {
                this.log.debug("doAuth({}@{}) GSS identity is {}", new Object[]{string, serverSession, this.identity});
            }
            if (!gSSAuthenticator.validateIdentity(serverSession, this.identity)) {
                return Boolean.FALSE;
            }
        }
        if (NumberUtils.length(byArray3) > 0) {
            object = serverSession.createBuffer((byte)61, byArray3.length + 32);
            ((Buffer)object).putBytes(byArray3);
            serverSession.writePacket((Buffer)object);
            return null;
        }
        return bl5;
    }

    @Override
    public void destroy() {
        if (this.context != null) {
            try {
                this.context.dispose();
            }
            catch (GSSException gSSException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed ({}) to dispose of context: {}", (Object)gSSException.getClass().getSimpleName(), (Object)gSSException.getMessage());
                }
            }
            finally {
                this.context = null;
            }
        }
    }

    public static Oid createOID(String string) {
        try {
            return new Oid(string);
        }
        catch (GSSException gSSException) {
            return null;
        }
    }
}

