/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;

public class StandardEnvironment
extends AbstractLoggingBean
implements Environment {
    private final Map listeners = new ConcurrentHashMap(Signal.SIGNALS.size());
    private final Map env = new ConcurrentHashMap();
    private final Map ptyModes = new ConcurrentHashMap(PtyMode.MODES.size());

    @Override
    public void addSignalListener(SignalListener signalListener, Collection collection) {
        SignalListener.validateListener(signalListener);
        ValidateUtils.checkNotNullAndNotEmpty(collection, "No signals", new Object[0]);
        for (Signal signal : collection) {
            Collection collection2 = this.getSignalListeners(signal, true);
            collection2.add(signalListener);
        }
    }

    @Override
    public Map getEnv() {
        return this.env;
    }

    @Override
    public Map getPtyModes() {
        return this.ptyModes;
    }

    @Override
    public void removeSignalListener(SignalListener signalListener) {
        if (signalListener == null) {
            return;
        }
        SignalListener.validateListener(signalListener);
        for (Signal signal : Signal.SIGNALS) {
            Collection collection = this.getSignalListeners(signal, false);
            if (collection == null) continue;
            collection.remove(signalListener);
        }
    }

    public void signal(Channel channel, Signal signal) {
        Collection collection = this.getSignalListeners(signal, false);
        if (this.log.isDebugEnabled()) {
            this.log.debug("signal({})[{}] - listeners={}", new Object[]{channel, signal, collection});
        }
        if (GenericUtils.isEmpty(collection)) {
            return;
        }
        boolean bl2 = this.log.isTraceEnabled();
        for (SignalListener signalListener : collection) {
            try {
                signalListener.signal(channel, signal);
                if (!bl2) continue;
                this.log.trace("signal({}) Signal {} to {}", new Object[]{channel, signal, signalListener});
            }
            catch (RuntimeException runtimeException) {
                this.log.warn("signal({}) Failed ({}) to signal {} to listener={}: {}", new Object[]{channel, runtimeException.getClass().getSimpleName(), signal, signalListener, runtimeException.getMessage()});
            }
        }
    }

    public void set(String string, String string2) {
        Map map = this.getEnv();
        map.put(ValidateUtils.checkNotNullAndNotEmpty(string, "Empty environment variable name"), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getSignalListeners(Signal signal, boolean bl2) {
        CopyOnWriteArraySet copyOnWriteArraySet = (CopyOnWriteArraySet)this.listeners.get((Object)signal);
        if (copyOnWriteArraySet == null && bl2) {
            Map map = this.listeners;
            synchronized (map) {
                copyOnWriteArraySet = (Collection)this.listeners.get((Object)signal);
                if (copyOnWriteArraySet == null) {
                    copyOnWriteArraySet = new CopyOnWriteArraySet();
                    this.listeners.put(signal, copyOnWriteArraySet);
                }
            }
        }
        return copyOnWriteArraySet;
    }

    public String toString() {
        return "env=" + this.getEnv() + ", modes=" + this.getPtyModes();
    }
}

