/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.session.ServerConnectionServiceFactory;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerUserAuthServiceFactory;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.ShellFactory;

public class SshServer
extends AbstractFactoryManager
implements Closeable,
ServerFactoryManager {
    public static final Factory DEFAULT_SSH_SERVER_FACTORY = SshServer::new;
    public static final List DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ServerUserAuthServiceFactory.INSTANCE, ServerConnectionServiceFactory.INSTANCE));
    protected IoAcceptor acceptor;
    protected String host;
    protected int port;
    private ServerProxyAcceptor proxyAcceptor;
    private ShellFactory shellFactory;
    private SessionFactory sessionFactory;
    private CommandFactory commandFactory;
    private List subsystemFactories;
    private List userAuthFactories;
    private KeyPairProvider keyPairProvider;
    private HostKeyCertificateProvider hostKeyCertificateProvider;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;
    private KeyboardInteractiveAuthenticator interactiveAuthenticator;
    private HostBasedAuthenticator hostBasedAuthenticator;
    private GSSAuthenticator gssAuthenticator;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public Set getBoundAddresses() {
        return this.acceptor == null ? Collections.emptySet() : this.acceptor.getBoundAddresses();
    }

    @Override
    public List getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List list) {
        this.userAuthFactories = list;
    }

    @Override
    public ShellFactory getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(ShellFactory shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ServerProxyAcceptor getServerProxyAcceptor() {
        return this.proxyAcceptor;
    }

    @Override
    public void setServerProxyAcceptor(ServerProxyAcceptor serverProxyAcceptor) {
        this.proxyAcceptor = serverProxyAcceptor;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public List getSubsystemFactories() {
        return this.subsystemFactories;
    }

    public void setSubsystemFactories(List list) {
        this.subsystemFactories = list;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    @Override
    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    @Override
    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator() {
        return this.interactiveAuthenticator;
    }

    @Override
    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator keyboardInteractiveAuthenticator) {
        this.interactiveAuthenticator = keyboardInteractiveAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.gssAuthenticator;
    }

    @Override
    public void setGSSAuthenticator(GSSAuthenticator gSSAuthenticator) {
        this.gssAuthenticator = gSSAuthenticator;
    }

    @Override
    public HostBasedAuthenticator getHostBasedAuthenticator() {
        return this.hostBasedAuthenticator;
    }

    @Override
    public void setHostBasedAuthenticator(HostBasedAuthenticator hostBasedAuthenticator) {
        this.hostBasedAuthenticator = hostBasedAuthenticator;
    }

    @Override
    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    @Override
    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }

    @Override
    public HostKeyCertificateProvider getHostKeyCertificateProvider() {
        return this.hostKeyCertificateProvider;
    }

    @Override
    public void setHostKeyCertificateProvider(HostKeyCertificateProvider hostKeyCertificateProvider) {
        this.hostKeyCertificateProvider = hostKeyCertificateProvider;
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        ValidateUtils.checkTrue(this.getPort() >= 0, "Bad port number: %d", (Object)this.getPort());
        List list = ServerAuthenticationManager.resolveUserAuthFactories(this);
        this.setUserAuthFactories((List)ValidateUtils.checkNotNullAndNotEmpty(list, "UserAuthFactories not set", new Object[0]));
        ValidateUtils.checkNotNullAndNotEmpty(this.getChannelFactories(), "ChannelFactories not set", new Object[0]);
        Objects.requireNonNull(this.getKeyPairProvider(), "HostKeyProvider not set");
        Objects.requireNonNull(this.getFileSystemFactory(), "FileSystemFactory not set");
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not start the server again");
        }
        if (this.isStarted()) {
            return;
        }
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.acceptor = this.createAcceptor();
        this.setupSessionTimeout(this.sessionFactory);
        String string = this.getHost();
        if (!GenericUtils.isEmpty(string)) {
            String[] stringArray;
            for (String string2 : stringArray = GenericUtils.split(string, ',')) {
                InetAddress[] inetAddressArray;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("start() - resolve bind host={}", (Object)string2);
                }
                for (InetAddress inetAddress : inetAddressArray = InetAddress.getAllByName(string2)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("start() - bind host={} / {}", (Object)string2, (Object)inetAddress);
                    }
                    this.acceptor.bind(new InetSocketAddress(inetAddress, this.port));
                    if (this.port != 0) continue;
                    SocketAddress socketAddress = (SocketAddress)GenericUtils.head(this.acceptor.getBoundAddresses());
                    this.port = ((InetSocketAddress)socketAddress).getPort();
                    this.log.info("start() listen on auto-allocated port={}", (Object)this.port);
                }
            }
        } else {
            this.acceptor.bind(new InetSocketAddress(this.port));
            if (this.port == 0) {
                SocketAddress socketAddress = (SocketAddress)GenericUtils.head(this.acceptor.getBoundAddresses());
                this.port = ((InetSocketAddress)socketAddress).getPort();
                this.log.info("start() listen on auto-allocated port={}", (Object)this.port);
            }
        }
        this.started.set(true);
    }

    public void stop() {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean bl2) {
        if (!this.started.getAndSet(false)) {
            return;
        }
        try {
            Duration duration = bl2 ? (Duration)CoreModuleProperties.STOP_WAIT_TIME.getRequired(this) : Duration.ofMillis(Long.MAX_VALUE);
            boolean bl3 = this.close(bl2).await(duration);
            if (!bl3) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + duration + " millis");
            }
        }
        finally {
            this.clearAttributes();
        }
    }

    public void open() {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        String string = this.toString();
        return this.builder().run(string, () -> this.removeSessionTimeout(this.sessionFactory)).sequential(this.acceptor, this.ioServiceFactory).run(string, () -> {
            this.acceptor = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    public List getActiveSessions() {
        ArrayList<AbstractSession> arrayList = new ArrayList<AbstractSession>();
        for (IoSession ioSession : this.acceptor.getManagedSessions().values()) {
            AbstractSession abstractSession = AbstractSession.getSession(ioSession, true);
            if (abstractSession == null) continue;
            arrayList.add(abstractSession);
        }
        return arrayList;
    }

    protected IoAcceptor createAcceptor() {
        IoServiceFactory ioServiceFactory = this.getIoServiceFactory();
        SessionFactory sessionFactory = this.getSessionFactory();
        return ioServiceFactory.createAcceptor(sessionFactory);
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toHexString(this.hashCode()) + "](port=" + this.getPort() + ")";
    }

    public static SshServer setUpDefaultServer() {
        ServerBuilder serverBuilder = ServerBuilder.builder();
        return (SshServer)serverBuilder.build();
    }
}

