/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.global.KeepAliveHandler;
import org.apache.sshd.common.kex.extension.DefaultServerKexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.keyboard.DefaultKeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.channel.ChannelSessionFactory;
import org.apache.sshd.server.config.keys.DefaultAuthorizedKeysAuthenticator;
import org.apache.sshd.server.forward.DirectTcpipFactory;
import org.apache.sshd.server.global.CancelTcpipForwardHandler;
import org.apache.sshd.server.global.NoMoreSessionsHandler;
import org.apache.sshd.server.global.OpenSshHostKeysHandler;
import org.apache.sshd.server.global.TcpipForwardHandler;
import org.apache.sshd.server.kex.DHGEXServer;
import org.apache.sshd.server.kex.DHGServer;

public class ServerBuilder
extends BaseBuilder {
    public static final Function DH2KEX = dHFactory -> dHFactory == null ? null : (dHFactory.isGroupExchange() ? DHGEXServer.newFactory(dHFactory) : DHGServer.newFactory(dHFactory));
    public static final List DEFAULT_CHANNEL_FACTORIES = Collections.unmodifiableList(Arrays.asList(ChannelSessionFactory.INSTANCE, DirectTcpipFactory.INSTANCE));
    public static final List DEFAULT_GLOBAL_REQUEST_HANDLERS = Collections.unmodifiableList(Arrays.asList(KeepAliveHandler.INSTANCE, NoMoreSessionsHandler.INSTANCE, TcpipForwardHandler.INSTANCE, CancelTcpipForwardHandler.INSTANCE, OpenSshHostKeysHandler.INSTANCE));
    public static final PublickeyAuthenticator DEFAULT_PUBLIC_KEY_AUTHENTICATOR = DefaultAuthorizedKeysAuthenticator.INSTANCE;
    public static final KeyboardInteractiveAuthenticator DEFAULT_INTERACTIVE_AUTHENTICATOR = DefaultKeyboardInteractiveAuthenticator.INSTANCE;
    public static final List DEFAULT_COMPRESSION_FACTORIES = Collections.unmodifiableList(Arrays.asList(BuiltinCompressions.none, BuiltinCompressions.zlib, BuiltinCompressions.delayedZlib));
    public static final KexExtensionHandler DEFAULT_KEX_EXTENSION_HANDLER = DefaultServerKexExtensionHandler.INSTANCE;
    protected PublickeyAuthenticator pubkeyAuthenticator;
    protected KeyboardInteractiveAuthenticator interactiveAuthenticator;

    public ServerBuilder interactiveAuthenticator(KeyboardInteractiveAuthenticator keyboardInteractiveAuthenticator) {
        this.interactiveAuthenticator = keyboardInteractiveAuthenticator;
        return this;
    }

    public ServerBuilder publickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.pubkeyAuthenticator = publickeyAuthenticator;
        return this;
    }

    @Override
    protected ServerBuilder fillWithDefaultValues() {
        super.fillWithDefaultValues();
        if (this.compressionFactories == null) {
            this.compressionFactories = ServerBuilder.setUpDefaultCompressionFactories(false);
        }
        if (this.signatureFactories == null) {
            this.signatureFactories = ServerBuilder.setUpDefaultSignatureFactories(false);
        }
        if (this.keyExchangeFactories == null) {
            this.keyExchangeFactories = ServerBuilder.setUpDefaultKeyExchanges(false);
        }
        if (this.kexExtensionHandler == null) {
            this.kexExtensionHandler = DEFAULT_KEX_EXTENSION_HANDLER;
        }
        if (this.channelFactories == null) {
            this.channelFactories = DEFAULT_CHANNEL_FACTORIES;
        }
        if (this.globalRequestHandlers == null) {
            this.globalRequestHandlers = DEFAULT_GLOBAL_REQUEST_HANDLERS;
        }
        if (this.pubkeyAuthenticator == null) {
            this.pubkeyAuthenticator = DEFAULT_PUBLIC_KEY_AUTHENTICATOR;
        }
        if (this.interactiveAuthenticator == null) {
            this.interactiveAuthenticator = DEFAULT_INTERACTIVE_AUTHENTICATOR;
        }
        if (this.factory == null) {
            this.factory = SshServer.DEFAULT_SSH_SERVER_FACTORY;
        }
        return (ServerBuilder)this.me();
    }

    @Override
    public SshServer build(boolean bl2) {
        SshServer sshServer = (SshServer)super.build(bl2);
        sshServer.setPublickeyAuthenticator(this.pubkeyAuthenticator);
        sshServer.setKeyboardInteractiveAuthenticator(this.interactiveAuthenticator);
        return sshServer;
    }

    public static List setUpDefaultSignatureFactories(boolean bl2) {
        return NamedFactory.setUpBuiltinFactories(bl2, DEFAULT_SIGNATURE_PREFERENCE);
    }

    public static List setUpDefaultCompressionFactories(boolean bl2) {
        return NamedFactory.setUpBuiltinFactories(bl2, DEFAULT_COMPRESSION_FACTORIES);
    }

    public static List setUpDefaultKeyExchanges(boolean bl2) {
        return NamedFactory.setUpTransformedFactories(bl2, DEFAULT_KEX_PREFERENCE, DH2KEX);
    }

    public static ServerBuilder builder() {
        return new ServerBuilder();
    }
}

