/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.auth.UserAuthFactoriesManager;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.keyprovider.KeyPairProviderHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.auth.BuiltinUserAuthFactories;
import org.apache.sshd.server.auth.BuiltinUserAuthFactories$ParseResult;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;

public interface ServerAuthenticationManager
extends UserAuthFactoriesManager,
KeyPairProviderHolder {
    public static final UserAuthPublicKeyFactory DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY = UserAuthPublicKeyFactory.INSTANCE;
    public static final UserAuthGSSFactory DEFAULT_USER_AUTH_GSS_FACTORY = UserAuthGSSFactory.INSTANCE;
    public static final UserAuthPasswordFactory DEFAULT_USER_AUTH_PASSWORD_FACTORY = UserAuthPasswordFactory.INSTANCE;
    public static final UserAuthKeyboardInteractiveFactory DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY = UserAuthKeyboardInteractiveFactory.INSTANCE;

    @Override
    default public void setUserAuthFactoriesNames(Collection collection) {
        BuiltinUserAuthFactories$ParseResult builtinUserAuthFactories$ParseResult = BuiltinUserAuthFactories.parseFactoriesList(collection);
        List list = (List)ValidateUtils.checkNotNullAndNotEmpty(builtinUserAuthFactories$ParseResult.getParsedFactories(), "No supported cipher factories: %s", collection);
        List list2 = builtinUserAuthFactories$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(list2), "Unsupported cipher factories found: %s", (Object)list2);
        this.setUserAuthFactories(list);
    }

    public PublickeyAuthenticator getPublickeyAuthenticator();

    public void setPasswordAuthenticator(PasswordAuthenticator var1);

    public PasswordAuthenticator getPasswordAuthenticator();

    public void setPublickeyAuthenticator(PublickeyAuthenticator var1);

    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator();

    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator var1);

    public GSSAuthenticator getGSSAuthenticator();

    public void setGSSAuthenticator(GSSAuthenticator var1);

    public HostBasedAuthenticator getHostBasedAuthenticator();

    public void setHostBasedAuthenticator(HostBasedAuthenticator var1);

    public HostKeyCertificateProvider getHostKeyCertificateProvider();

    public void setHostKeyCertificateProvider(HostKeyCertificateProvider var1);

    public static List resolveUserAuthFactories(ServerAuthenticationManager serverAuthenticationManager) {
        if (serverAuthenticationManager == null) {
            return Collections.emptyList();
        }
        return ServerAuthenticationManager.resolveUserAuthFactories(serverAuthenticationManager, serverAuthenticationManager.getUserAuthFactories());
    }

    public static List resolveUserAuthFactories(ServerAuthenticationManager serverAuthenticationManager, List list) {
        if (GenericUtils.size(list) > 0) {
            return list;
        }
        if (serverAuthenticationManager == null) {
            return Collections.emptyList();
        }
        ArrayList<UserAuthFactory> arrayList = new ArrayList<UserAuthFactory>();
        if (serverAuthenticationManager.getPasswordAuthenticator() != null) {
            arrayList.add(DEFAULT_USER_AUTH_PASSWORD_FACTORY);
            arrayList.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        } else if (serverAuthenticationManager.getKeyboardInteractiveAuthenticator() != null) {
            arrayList.add(DEFAULT_USER_AUTH_KB_INTERACTIVE_FACTORY);
        }
        if (serverAuthenticationManager.getPublickeyAuthenticator() != null) {
            arrayList.add(DEFAULT_USER_AUTH_PUBLIC_KEY_FACTORY);
        }
        if (serverAuthenticationManager.getGSSAuthenticator() != null) {
            arrayList.add(DEFAULT_USER_AUTH_GSS_FACTORY);
        }
        return arrayList;
    }
}

