/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.NoCloseExecutor;
import org.apache.sshd.common.util.threads.SshThreadPoolExecutor;
import org.apache.sshd.common.util.threads.SshdThreadFactory;
import org.apache.sshd.common.util.threads.ThreadUtils$1;

public final class ThreadUtils {
    private static final ThreadLocal IS_INTERNAL_THREAD = new ThreadLocal();

    private ThreadUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Object runAsInternal(Callable callable) {
        if (ThreadUtils.isInternalThread()) {
            return callable.call();
        }
        try {
            IS_INTERNAL_THREAD.set(Boolean.TRUE);
            Object v2 = callable.call();
            return v2;
        }
        finally {
            IS_INTERNAL_THREAD.remove();
        }
    }

    public static Object runAsInternal(Object object, IOFunction iOFunction) {
        if (ThreadUtils.isInternalThread()) {
            return iOFunction.apply(object);
        }
        try {
            IS_INTERNAL_THREAD.set(Boolean.TRUE);
            Object object2 = iOFunction.apply(object);
            return object2;
        }
        finally {
            IS_INTERNAL_THREAD.remove();
        }
    }

    public static boolean isInternalThread() {
        return Boolean.TRUE.equals(IS_INTERNAL_THREAD.get());
    }

    public static CloseableExecutorService protectExecutorServiceShutdown(CloseableExecutorService closeableExecutorService, boolean bl2) {
        if (closeableExecutorService == null || bl2 || closeableExecutorService instanceof NoCloseExecutor) {
            return closeableExecutorService;
        }
        return new NoCloseExecutor(closeableExecutorService);
    }

    public static CloseableExecutorService noClose(CloseableExecutorService closeableExecutorService) {
        return ThreadUtils.protectExecutorServiceShutdown(closeableExecutorService, false);
    }

    public static ClassLoader resolveDefaultClassLoader(Object object) {
        return ThreadUtils.resolveDefaultClassLoader(object == null ? null : object.getClass());
    }

    public static Iterable resolveDefaultClassLoaders(Object object) {
        return ThreadUtils.resolveDefaultClassLoaders(object == null ? null : object.getClass());
    }

    public static Iterable resolveDefaultClassLoaders(Class clazz) {
        return () -> ThreadUtils.iterateDefaultClassLoaders(clazz);
    }

    public static Class resolveDefaultClass(Class clazz, String string) {
        return ThreadUtils.resolveDefaultClass(ThreadUtils.resolveDefaultClassLoaders(clazz), string);
    }

    public static Class resolveDefaultClass(Iterable iterable, String string) {
        for (ClassLoader classLoader : iterable) {
            try {
                return classLoader.loadClass(string);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static Object createDefaultInstance(Class clazz, Class clazz2, String string) {
        return ThreadUtils.createDefaultInstance(ThreadUtils.resolveDefaultClassLoaders(clazz), clazz2, string);
    }

    public static Object createDefaultInstance(ClassLoader classLoader, Class clazz, String string) {
        Class<?> clazz2 = classLoader.loadClass(string);
        return ReflectionUtils.newInstance(clazz2, clazz);
    }

    public static Object createDefaultInstance(Iterable iterable, Class clazz, String string) {
        for (ClassLoader classLoader : iterable) {
            try {
                return ThreadUtils.createDefaultInstance(classLoader, clazz, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(string);
    }

    public static ClassLoader resolveDefaultClassLoader(Class clazz) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Iterator iterateDefaultClassLoaders(Class clazz) {
        Class clazz2 = clazz == null ? ThreadUtils.class : clazz;
        return new ThreadUtils$1(clazz2);
    }

    public static CloseableExecutorService newFixedThreadPoolIf(CloseableExecutorService closeableExecutorService, String string, int n2) {
        return closeableExecutorService == null ? ThreadUtils.newFixedThreadPool(string, n2) : closeableExecutorService;
    }

    public static CloseableExecutorService newFixedThreadPool(String string, int n2) {
        return new SshThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new SshdThreadFactory(string), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static CloseableExecutorService newCachedThreadPoolIf(CloseableExecutorService closeableExecutorService, String string) {
        return closeableExecutorService == null ? ThreadUtils.newCachedThreadPool(string) : closeableExecutorService;
    }

    public static CloseableExecutorService newCachedThreadPool(String string) {
        return new SshThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), (ThreadFactory)new SshdThreadFactory(string), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String string) {
        return new ScheduledThreadPoolExecutor(1, new SshdThreadFactory(string));
    }

    public static CloseableExecutorService newSingleThreadExecutor(String string) {
        return ThreadUtils.newFixedThreadPool(string, 1);
    }
}

