/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SshdThreadFactory
extends AbstractLoggingBean
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public SshdThreadFactory(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        String string2 = string.replace(' ', '-');
        this.namePrefix = "sshd-" + string2 + "-thread-";
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread;
        try {
            thread = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L)) : new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalStateException(exception);
        }
        if (!thread.isDaemon()) {
            thread.setDaemon(true);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("newThread({})[{}] runnable={}", new Object[]{this.group, thread.getName(), runnable});
        }
        return thread;
    }
}

